/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short year;
    private short month;
    private short day;
    private short hour;
    private short minute;
    private short second;
    private short millis;
    private boolean negative;
    private static final Pattern durationPattern = Pattern.compile("(-)?P(?:(\\p{Digit}+)Y)?(?:(\\p{Digit}+)M)?(?:(\\p{Digit}+)D)?(?:T(?:(\\p{Digit}+)H)?(?:(\\p{Digit}+)M)?(?:(\\p{Digit}+)(?:\\.(\\p{Digit}{1,3})\\p{Digit}*)?S)?)?");
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final long WEEK = 604800000L;
    static final long MONTH = 2592000000L;
    static final long YEAR = 31536000000L;

    public Duration() {
    }

    public Duration(int year, int month, int day, int hour, int minute, int second, int millis) {
        this.setYear((short)year);
        this.setMonth((short)month);
        this.setDay((short)day);
        this.setHour((short)hour);
        this.setMinute((short)minute);
        this.setSecond((short)second);
        this.setMillis((short)millis);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public short getYear() {
        return this.year;
    }

    public void setYear(short year) {
        this.year = year;
    }

    public short getMonth() {
        return this.month;
    }

    public void setMonth(short month) {
        this.month = month;
    }

    public short getDay() {
        return this.day;
    }

    public void setDay(short day) {
        this.day = day;
    }

    public short getHour() {
        return this.hour;
    }

    public void setHour(short hour) {
        this.hour = hour;
    }

    public short getMinute() {
        return this.minute;
    }

    public void setMinute(short minute) {
        this.minute = minute;
    }

    public short getSecond() {
        return this.second;
    }

    public void setSecond(short second) {
        this.second = second;
    }

    public short getMillis() {
        return this.millis;
    }

    public void setMillis(short millis) {
        this.millis = millis;
    }

    public void addTo(Date dateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        this.addTo(calendar);
        dateTime.setTime(calendar.getTimeInMillis());
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.year);
        calendar.add(2, this.month);
        calendar.add(5, this.day);
        calendar.add(11, this.hour);
        calendar.add(12, this.minute);
        calendar.add(13, this.second);
        calendar.add(14, this.millis);
    }

    public long getTimeInMillis() {
        long timeInMillis = this.millis;
        timeInMillis += 1000L * (long)this.second;
        timeInMillis += 60000L * (long)this.minute;
        timeInMillis += 3600000L * (long)this.hour;
        timeInMillis += 86400000L * (long)this.day;
        timeInMillis += 2592000000L * (long)this.month;
        return timeInMillis += 31536000000L * (long)this.year;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Duration) {
            Duration d = (Duration)obj;
            equals = this.year == d.year && this.month == d.month && this.day == d.day && this.hour == d.hour && this.minute == d.minute && this.second == d.second && this.millis == d.millis && this.negative == d.negative;
        }
        return equals;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.year).append(this.month).append(this.day).append(this.hour).append(this.minute).append(this.second).append(this.millis).append(this.negative).toHashCode();
    }

    public String toString() {
        StringBuffer literal = new StringBuffer();
        if (this.negative) {
            literal.append('-');
        }
        literal.append('P');
        if (this.year != 0) {
            literal.append(this.year).append('Y');
        }
        if (this.month != 0) {
            literal.append(this.month).append('M');
        }
        if (this.day != 0) {
            literal.append(this.day).append('D');
        }
        if (this.hour != 0 || this.minute != 0 || this.second != 0 || this.millis != 0) {
            literal.append('T');
            if (this.hour != 0) {
                literal.append(this.hour).append('H');
            }
            if (this.minute != 0) {
                literal.append(this.minute).append('M');
            }
            if (this.second != 0) {
                literal.append(this.second);
                if (this.millis != 0) {
                    literal.append('.').append(Duration.formatDecimal(this.millis, 3));
                }
                literal.append('S');
            } else if (this.millis != 0) {
                literal.append('0').append(Duration.formatDecimal(this.millis, 3)).append('S');
            }
        }
        return literal.toString();
    }

    public static Duration parseDuration(String literal) {
        Matcher matcher = durationPattern.matcher(literal);
        Duration duration = null;
        if (matcher.matches()) {
            String group;
            duration = new Duration();
            if (matcher.group(1) != null) {
                duration.setNegative(true);
            }
            if ((group = matcher.group(2)) != null) {
                duration.setYear(Short.parseShort(group));
            }
            if ((group = matcher.group(3)) != null) {
                duration.setMonth(Short.parseShort(group));
            }
            if ((group = matcher.group(4)) != null) {
                duration.setDay(Short.parseShort(group));
            }
            if ((group = matcher.group(5)) != null) {
                duration.setHour(Short.parseShort(group));
            }
            if ((group = matcher.group(6)) != null) {
                duration.setMinute(Short.parseShort(group));
            }
            if ((group = matcher.group(7)) != null) {
                duration.setSecond(Short.parseShort(group));
            }
            if ((group = matcher.group(8)) != null) {
                duration.setMillis(Duration.parseDecimal(group, 3));
            }
        }
        return duration;
    }

    private static short parseDecimal(String literal, int digitCount) {
        short number = Short.parseShort(literal);
        int n = digitCount - literal.length();
        for (int i = 0; i < n; ++i) {
            number = (short)(number * 10);
        }
        return number;
    }

    private static String formatDecimal(short number, int digitCount) {
        String literal = Short.toString(number);
        if (literal.length() < digitCount) {
            StringBuffer buffer = new StringBuffer();
            int n = digitCount - literal.length();
            for (int i = 0; i < n; ++i) {
                buffer.append('0');
            }
            literal = buffer.append(literal).toString();
        }
        int i = digitCount;
        while (--i > 0 && literal.charAt(i) == '0') {
        }
        return literal.substring(0, i + 1);
    }
}

