/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.xml.ProblemCounter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.jpdl.xml.Problem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProcessWsdlLocator
implements WSDLLocator {
    private URI processURI;
    private String baseURI;
    private String latestImportURI;
    private ProblemHandler problemHandler = new ProblemCounter();
    private static Templates wsdlUpgradeTemplates;
    public static final URI EMPTY_URI;
    private static final String UPGRADABLE_ELEMENTS_XPATH = "*[namespace-uri() = 'http://schemas.xmlsoap.org/ws/2003/03/business-process/' or namespace-uri() = 'http://schemas.xmlsoap.org/ws/2003/05/partner-link/']";
    private static final Log log;

    public ProcessWsdlLocator(URI processURI) {
        if (processURI == null) {
            throw new IllegalArgumentException("process URI cannot be null");
        }
        this.processURI = processURI;
    }

    public URI getProcessURI() {
        return this.processURI;
    }

    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        if (problemHandler == null) {
            throw new IllegalArgumentException("problem handler cannot be null");
        }
        this.problemHandler = problemHandler;
    }

    public void resolveBaseURI(String baseLocation) {
        try {
            this.baseURI = this.processURI.resolve(new URI(baseLocation)).toString();
        }
        catch (URISyntaxException e) {
            log.debug((Object)"base location is not a valid URI, setting baseURI to null", (Throwable)e);
            this.baseURI = null;
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputSource getBaseInputSource() {
        this.latestImportURI = this.baseURI;
        InputSource inputSource = this.createInputSource(this.baseURI);
        this.upgradeWsdlDocumentIfNeeded(inputSource);
        return inputSource;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        try {
            URI importURI = new URI(importLocation);
            if (!importURI.isAbsolute()) {
                importLocation = new URI(parentLocation).resolve(importURI).toString();
            }
            this.latestImportURI = importLocation;
            InputSource inputSource = this.createInputSource(importLocation);
            this.upgradeWsdlDocumentIfNeeded(inputSource);
            return inputSource;
        }
        catch (URISyntaxException e) {
            log.debug((Object)"import location is not a valid URI, returning null source", (Throwable)e);
            return null;
        }
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
    }

    protected InputSource createInputSource(String documentLocation) {
        return new InputSource(documentLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeWsdlDocumentIfNeeded(InputSource source) {
        Document document;
        DocumentBuilder documentParser = XmlUtil.getDocumentBuilder();
        documentParser.setErrorHandler(this.problemHandler.asSaxErrorHandler());
        try {
            document = documentParser.parse(source);
            if (this.problemHandler.getProblemCount() > 0) {
                return;
            }
        }
        catch (IOException e) {
            Problem problem = new Problem(2, "document is not readable", (Throwable)e);
            problem.setResource(this.latestImportURI);
            this.problemHandler.add(problem);
            return;
        }
        catch (SAXException e) {
            Problem problem = new Problem(2, "document contains invalid xml", (Throwable)e);
            problem.setResource(this.latestImportURI);
            this.problemHandler.add(problem);
            return;
        }
        finally {
            documentParser.setErrorHandler(null);
        }
        if (ProcessWsdlLocator.hasUpgradableElements(document)) {
            try {
                Transformer wsdlUpgrader = ProcessWsdlLocator.getWsdlUpgradeTemplates().newTransformer();
                wsdlUpgrader.setErrorListener(this.problemHandler.asTraxErrorListener());
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                wsdlUpgrader.transform(new DOMSource(document), new StreamResult(resultStream));
                source.setByteStream(new ByteArrayInputStream(resultStream.toByteArray()));
                log.debug((Object)("upgraded wsdl document: " + this.latestImportURI));
            }
            catch (TransformerException e) {
                Problem problem = new Problem(2, "wsdl upgrade failed", (Throwable)e);
                problem.setResource(this.latestImportURI);
                this.problemHandler.add(problem);
            }
        } else {
            InputStream sourceStream = source.getByteStream();
            if (sourceStream != null) {
                try {
                    sourceStream.reset();
                }
                catch (IOException e) {
                    log.error((Object)("could not reset source stream: " + this.latestImportURI), (Throwable)e);
                }
            }
        }
    }

    static synchronized Templates getWsdlUpgradeTemplates() {
        if (wsdlUpgradeTemplates == null) {
            wsdlUpgradeTemplates = XmlUtil.createTemplates(ProcessWsdlLocator.class.getResource("wsdl-1-1-converter.xslt"));
        }
        return wsdlUpgradeTemplates;
    }

    private static boolean hasUpgradableElements(Document wsdlDocument) {
        Object upgradableElements = XmlUtil.evaluateXPath(UPGRADABLE_ELEMENTS_XPATH, wsdlDocument.getDocumentElement(), null);
        return upgradableElements != null;
    }

    static {
        EMPTY_URI = URI.create("");
        log = LogFactory.getLog((Class)ProcessWsdlLocator.class);
    }
}

