/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.xml.Problem;

class ErrorListenerAdapter
implements ErrorListener {
    private final ProblemHandler handler;

    ErrorListenerAdapter(ProblemHandler handler) {
        this.handler = handler;
    }

    public void error(TransformerException te) {
        Problem problem = new Problem(2, te.getMessage(), te.getException());
        this.fillLocationData(problem, te.getLocator());
        this.handler.add(problem);
    }

    public void fatalError(TransformerException te) {
        Problem problem = new Problem(1, te.getMessage(), te.getException());
        this.fillLocationData(problem, te.getLocator());
        this.handler.add(problem);
    }

    public void warning(TransformerException te) {
        Problem problem = new Problem(3, te.getMessage(), te.getException());
        this.fillLocationData(problem, te.getLocator());
        this.handler.add(problem);
    }

    private void fillLocationData(Problem problem, SourceLocator locator) {
        if (locator == null) {
            return;
        }
        String resource = locator.getPublicId();
        if (resource == null) {
            resource = locator.getSystemId();
        }
        problem.setResource(resource);
        problem.setLine(new Integer(locator.getLineNumber()));
    }
}

