/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.Set;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.PathExpr;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.sublang.def.JoinCondition;
import org.jbpm.bpel.sublang.def.Query;
import org.jbpm.bpel.sublang.exe.EvaluatorFactory;
import org.jbpm.bpel.sublang.exe.ExpressionEvaluator;
import org.jbpm.bpel.sublang.exe.QueryEvaluator;
import org.jbpm.bpel.sublang.xpath.ExprVisitor;
import org.jbpm.bpel.sublang.xpath.SetNamespaceContext;
import org.jbpm.bpel.sublang.xpath.XPathExpressionEvaluator;
import org.jbpm.bpel.sublang.xpath.XPathJoinConditionEvaluator;
import org.jbpm.bpel.sublang.xpath.XPathQueryEvaluator;

public class XPathEvaluatorFactory
extends EvaluatorFactory {
    private static final XPathEvaluatorFactory instance = new XPathEvaluatorFactory();

    public static EvaluatorFactory getInstance() {
        return instance;
    }

    public ExpressionEvaluator createEvaluator(Expression expression) {
        XPathExpressionEvaluator evaluator;
        String text = expression.getText();
        try {
            evaluator = expression instanceof JoinCondition ? XPathEvaluatorFactory.createJoinConditionEvaluator(text) : XPathEvaluatorFactory.createExpressionEvaluator(text);
        }
        catch (JaxenException e) {
            throw new BpelException("could not create evaluator: expression=" + expression, (Exception)((Object)e));
        }
        Set namespaces = expression.getNamespaces();
        if (namespaces != null) {
            evaluator.setNamespaceContext(new SetNamespaceContext(namespaces));
        }
        return evaluator;
    }

    public QueryEvaluator createEvaluator(Query query) {
        XPathQueryEvaluator evaluator;
        try {
            evaluator = new XPathQueryEvaluator(query.getText());
        }
        catch (JaxenException e) {
            throw new BpelException("could not create evaluator: query=" + query, (Exception)((Object)e));
        }
        Set namespaces = query.getNamespaces();
        if (namespaces != null) {
            evaluator.setNamespaceContext(new SetNamespaceContext(namespaces));
        }
        return evaluator;
    }

    static XPathExpressionEvaluator createExpressionEvaluator(String text) throws JaxenException {
        XPathExpressionEvaluator expression = new XPathExpressionEvaluator(text);
        if (!new ExprValidator().validate(expression.getRootExpr())) {
            throw new XPathSyntaxException(text, 0, "illegal access to root/context node");
        }
        return expression;
    }

    static XPathQueryEvaluator createQueryEvaluator(String text) throws JaxenException {
        XPathQueryEvaluator aliasQuery = new XPathQueryEvaluator(text);
        if (!(aliasQuery.getRootExpr() instanceof LocationPath)) {
            throw new XPathSyntaxException(text, 0, "not a location path");
        }
        return aliasQuery;
    }

    static XPathJoinConditionEvaluator createJoinConditionEvaluator(String text) throws JaxenException {
        XPathJoinConditionEvaluator joinCondition = new XPathJoinConditionEvaluator(text);
        if (!new ExprValidator().validate(joinCondition.getRootExpr())) {
            throw new XPathSyntaxException(text, 0, "illegal access to root/context node");
        }
        return joinCondition;
    }

    private static class ExprValidator
    extends ExprVisitor {
        private boolean valid;

        private ExprValidator() {
        }

        public boolean validate(Expr expr) {
            this.valid = true;
            this.visit(expr);
            return this.valid;
        }

        public void visit(PathExpr expr) {
            this.visit(expr.getFilterExpr());
        }

        public void visit(LocationPath locationPath) {
            this.valid = false;
        }
    }
}

