/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.app.AppMyRole;
import org.jbpm.bpel.app.AppPartnerLink;
import org.jbpm.bpel.app.AppPartnerRole;
import org.jbpm.bpel.app.AppScope;
import org.jbpm.bpel.graph.def.BpelVisitorSupport;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.integration.jms.PartnerLinkEntry;

class PartnerLinkEntriesBuilder
extends BpelVisitorSupport {
    private final Map scopeDescriptors;
    private final Context jmsContext;
    private final Destination defaultDestination;
    private Map partnerLinkEntriesById = new HashMap();
    private Map partnerLinkEntriesByHandle = new HashMap();
    private static final Log log = LogFactory.getLog((Class)PartnerLinkEntriesBuilder.class);

    PartnerLinkEntriesBuilder(Map scopeDescriptors, Context jmsContext, Destination defaultDestination) {
        this.scopeDescriptors = scopeDescriptors;
        this.jmsContext = jmsContext;
        this.defaultDestination = defaultDestination;
    }

    public Map getPartnerLinkEntriesById() {
        return this.partnerLinkEntriesById;
    }

    public Map getPartnerLinkEntriesByHandle() {
        return this.partnerLinkEntriesByHandle;
    }

    public void visit(Scope scope) {
        AppScope appScope = (AppScope)this.scopeDescriptors.get((Object)scope);
        Map appPartnerLinks = appScope != null ? appScope.getPartnerLinks() : Collections.EMPTY_MAP;
        Iterator partnerLinkIt = scope.getPartnerLinks().values().iterator();
        while (partnerLinkIt.hasNext()) {
            PartnerLinkDefinition definition = (PartnerLinkDefinition)partnerLinkIt.next();
            AppPartnerLink descriptor = (AppPartnerLink)appPartnerLinks.get(definition.getName());
            PartnerLinkEntry entry = this.buildEntry(definition, descriptor);
            this.partnerLinkEntriesById.put(new Long(entry.getId()), entry);
            this.partnerLinkEntriesByHandle.put(entry.getHandle(), entry);
        }
        scope.getActivity().accept(this);
    }

    protected PartnerLinkEntry buildEntry(PartnerLinkDefinition definition, AppPartnerLink descriptor) {
        PartnerLinkEntry entry = new PartnerLinkEntry();
        entry.setId(definition.getId());
        entry.setHandle(definition.getName());
        entry.setInitiateMode(AppPartnerRole.InitiateMode.PULL);
        if (descriptor != null) {
            AppPartnerRole partnerRole;
            AppMyRole myRole = descriptor.getMyRole();
            if (myRole != null) {
                if (definition.getMyRole() == null) {
                    throw new BpelException("partner link has no my role: " + definition.getName());
                }
                String handle = myRole.getHandle();
                if (handle != null) {
                    entry.setHandle(handle);
                }
            }
            if ((partnerRole = descriptor.getPartnerRole()) != null) {
                if (definition.getPartnerRole() == null) {
                    throw new BpelException("partner link has no partner role: " + definition.getName());
                }
                entry.setPartnerReference(partnerRole.getEndpointReference());
                entry.setInitiateMode(partnerRole.getInitiateMode());
            }
        }
        if (definition.getMyRole() != null) {
            entry.setDestination(this.getDestination(entry.getHandle()));
        }
        return entry;
    }

    protected Destination getDestination(String partnerLinkHandle) {
        Destination destination;
        try {
            destination = (Destination)this.jmsContext.lookup(partnerLinkHandle);
            log.debug((Object)("retrieved jms destination: " + partnerLinkHandle));
        }
        catch (NamingException e) {
            if (this.defaultDestination == null) {
                throw new BpelException("could not retrieve jms destination: " + partnerLinkHandle, e);
            }
            destination = this.defaultDestination;
        }
        return destination;
    }
}

