/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.graph.exe.EventInstance;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.scope.Catch;
import org.jbpm.bpel.graph.scope.FaultActionHandler;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.NestedScopeFinder;
import org.jbpm.bpel.graph.scope.OnAlarm;
import org.jbpm.bpel.graph.scope.OnEvent;
import org.jbpm.bpel.integration.def.CorrelationSetDefinition;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;

public class Scope
extends CompositeActivity {
    private Activity activity;
    private Map variables = new HashMap();
    private Map partnerLinks = new HashMap();
    private Map correlationSets = new HashMap();
    private Handler compensationHandler;
    private Handler terminationHandler;
    private Handler catchAll;
    private List faultHandlers = new ArrayList();
    private Collection onEvents = new HashSet();
    private Collection onAlarms = new HashSet();
    private boolean isolated;
    private boolean implicit;
    public static final String VARIABLE_NAME = "s:instance";
    private static final Log log = LogFactory.getLog((Class)Scope.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private static final long serialVersionUID = 1L;
    private static final Predicate UNNAMED_CATCH_PREDICATE = new Predicate(){

        public boolean evaluate(Object arg) {
            Catch catcher = (Catch)arg;
            return catcher.getFaultName() == null;
        }
    };
    static /* synthetic */ Class class$org$jbpm$bpel$variable$def$MessageType;

    public Scope() {
    }

    public Scope(String name) {
        super(name);
    }

    public void execute(ExecutionContext exeContext) {
        Token scopeToken = new Token(exeContext.getToken(), this.name);
        ScopeInstance scopeInstance = this.createInstance(scopeToken);
        scopeInstance.initializeData();
        scopeInstance.enableEvents();
        Token primaryToken = scopeInstance.getPrimaryToken();
        this.activity.enter(new ExecutionContext(primaryToken));
    }

    public void terminate(ExecutionContext context) {
        Token scopeToken = context.getToken().getChild(this.name);
        ScopeInstance scopeInstance = Scope.getInstance(scopeToken);
        scopeInstance.terminate();
    }

    public void eliminatePath(Token token) {
        this.activity.eliminatePath(token);
        super.eliminatePath(token);
    }

    public void complete(ScopeInstance parent) {
        new ExecutionContext(parent.getToken()).leaveNode();
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }

    public void installFaultExceptionHandler() {
        ExceptionHandler faultExceptionHandler = new ExceptionHandler();
        faultExceptionHandler.setExceptionClassName(BpelFaultException.class.getName());
        faultExceptionHandler.addAction(new Action(new Delegation(FaultActionHandler.class.getName())));
        this.addExceptionHandler(faultExceptionHandler);
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        if (this.activity != null) {
            this.unsetActivity();
        }
        if (activity != null) {
            activity.detachFromParent();
            this.adoptActivity(activity);
            this.activity = activity;
        }
    }

    private void unsetActivity() {
        this.disadoptActivity(this.activity);
        this.activity = null;
    }

    public VariableDefinition getVariable(String variableName) {
        return (VariableDefinition)this.variables.get(variableName);
    }

    public Map getVariables() {
        return this.variables;
    }

    public void addVariable(VariableDefinition variable) {
        this.variables.put(variable.getName(), variable);
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    public CorrelationSetDefinition getCorrelationSet(String correlationSetName) {
        return (CorrelationSetDefinition)this.correlationSets.get(correlationSetName);
    }

    public Map getCorrelationSets() {
        return this.correlationSets;
    }

    public void addCorrelationSet(CorrelationSetDefinition correlation) {
        this.correlationSets.put(correlation.getName(), correlation);
    }

    public void setCorrelationSets(Map correlationSets) {
        this.correlationSets = correlationSets;
    }

    public PartnerLinkDefinition getPartnerLink(String plinkName) {
        return (PartnerLinkDefinition)this.partnerLinks.get(plinkName);
    }

    public Map getPartnerLinks() {
        return this.partnerLinks;
    }

    public void addPartnerLink(PartnerLinkDefinition partnerLink) {
        this.partnerLinks.put(partnerLink.getName(), partnerLink);
    }

    public void setPartnerLinks(Map partnerLinks) {
        this.partnerLinks = partnerLinks;
    }

    public Handler getCompensationHandler() {
        return this.compensationHandler;
    }

    public void setCompensationHandler(Handler handler) {
        if (this.compensationHandler != null) {
            this.disadoptActivity(this.compensationHandler);
        }
        this.adoptActivity(handler);
        this.compensationHandler = handler;
    }

    public Handler getTerminationHandler() {
        return this.terminationHandler;
    }

    public void setTerminationHandler(Handler handler) {
        if (this.terminationHandler != null) {
            this.disadoptActivity(this.terminationHandler);
        }
        this.adoptActivity(handler);
        this.terminationHandler = handler;
    }

    public Handler getCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(Handler handler) {
        if (this.catchAll != null) {
            this.disadoptActivity(this.catchAll);
        }
        this.adoptActivity(handler);
        this.catchAll = handler;
    }

    public List getFaultHandlers() {
        return this.faultHandlers;
    }

    public void addCatch(Catch catcher) {
        this.adoptActivity(catcher);
        this.faultHandlers.add(catcher);
    }

    public Handler selectFaultHandler(QName name, VariableType dataType) {
        Catch selectedCatch;
        if (dataType == null) {
            selectedCatch = this.selectCatch(name);
        } else if (name != null) {
            selectedCatch = this.selectCatch(name, dataType);
            if (selectedCatch == null) {
                selectedCatch = this.selectCatch(dataType);
            }
        } else {
            selectedCatch = this.selectCatch(dataType);
        }
        return selectedCatch != null ? selectedCatch : this.catchAll;
    }

    public Catch selectCatch(QName name) {
        if (traceEnabled) {
            log.trace((Object)("looking for fault handler with name '" + name + "' and no variable"));
        }
        FilterIterator namedCatchIt = new FilterIterator(this.faultHandlers.iterator(), (Predicate)new NamedCatchPredicate(name));
        while (namedCatchIt.hasNext()) {
            Catch namedCatch = (Catch)namedCatchIt.next();
            if (traceEnabled) {
                log.trace((Object)("examining catch: " + namedCatch));
            }
            if (namedCatch.getFaultVariable() != null) continue;
            if (traceEnabled) {
                log.trace((Object)("selected catch with matching name: " + namedCatch));
            }
            return namedCatch;
        }
        return null;
    }

    public Catch selectCatch(QName name, VariableType dataType) {
        if (traceEnabled) {
            log.trace((Object)("looking for fault handler with name '" + name + "' and variable type '" + dataType + '\''));
        }
        FilterIterator namedCatchIt = new FilterIterator(this.faultHandlers.iterator(), (Predicate)new NamedCatchPredicate(name));
        return Scope.selectCatch((Iterator)namedCatchIt, dataType);
    }

    public Catch selectCatch(VariableType dataType) {
        if (traceEnabled) {
            log.trace((Object)("looking for fault handler with no name and variable type '" + dataType));
        }
        FilterIterator unnamedCatchIt = new FilterIterator(this.faultHandlers.iterator(), UNNAMED_CATCH_PREDICATE);
        return Scope.selectCatch((Iterator)unnamedCatchIt, dataType);
    }

    private static Catch selectCatch(Iterator handlerIt, VariableType dataType) {
        Catch selectedCatch = null;
        while (handlerIt.hasNext()) {
            VariableDefinition variable;
            Catch currentCatch = (Catch)handlerIt.next();
            if (traceEnabled) {
                log.trace((Object)("examining catch: " + currentCatch));
            }
            if ((variable = currentCatch.getFaultVariable()) != null) {
                MessageType messageType;
                VariableType handlerType = variable.getType();
                if (handlerType.equals(dataType)) {
                    selectedCatch = currentCatch;
                    if (!traceEnabled) break;
                    log.trace((Object)("selected catch with matching type: " + selectedCatch));
                    break;
                }
                if (!dataType.isMessage() || !handlerType.isElement()) continue;
                if (dataType instanceof MessageType) {
                    messageType = (MessageType)dataType;
                } else {
                    Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
                    messageType = (MessageType)hbSession.load(class$org$jbpm$bpel$variable$def$MessageType == null ? Scope.class$("org.jbpm.bpel.variable.def.MessageType") : class$org$jbpm$bpel$variable$def$MessageType, hbSession.getIdentifier((Object)dataType));
                }
                QName elementName = WsdlUtil.getDocLitElementName(messageType.getMessage());
                if (!handlerType.getName().equals(elementName)) continue;
                selectedCatch = currentCatch;
                if (!traceEnabled) continue;
                log.trace((Object)("selected catch with matching element: " + selectedCatch));
                continue;
            }
            if (selectedCatch != null) continue;
            selectedCatch = currentCatch;
            if (!traceEnabled) continue;
            log.trace((Object)("selected catch with no type:" + selectedCatch));
        }
        return selectedCatch;
    }

    public Collection getOnEvents() {
        return this.onEvents;
    }

    public void addOnEvent(OnEvent onEvent) {
        this.adoptActivity(onEvent);
        this.onEvents.add(onEvent);
    }

    public Collection getOnAlarms() {
        return this.onAlarms;
    }

    public void addOnAlarm(OnAlarm onAlarm) {
        this.adoptActivity(onAlarm);
        this.onAlarms.add(onAlarm);
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isScope() {
        return true;
    }

    public VariableDefinition findVariable(String name) {
        VariableDefinition variable = this.getVariable(name);
        return variable != null ? variable : super.findVariable(name);
    }

    public CorrelationSetDefinition findCorrelationSet(String name) {
        CorrelationSetDefinition correlationSet = this.getCorrelationSet(name);
        return correlationSet != null ? correlationSet : super.findCorrelationSet(name);
    }

    public PartnerLinkDefinition findPartnerLink(String name) {
        PartnerLinkDefinition partnerLink = this.getPartnerLink(name);
        return partnerLink != null ? partnerLink : super.findPartnerLink(name);
    }

    public Node addNode(Node node) {
        if (!(node instanceof Activity)) {
            throw new IllegalArgumentException("not an activity: " + node);
        }
        this.setActivity((Activity)node);
        return node;
    }

    public Node removeNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!node.equals((Object)this.activity)) {
            return null;
        }
        this.unsetActivity();
        return node;
    }

    public void reorderNode(int oldIndex, int newIndex) {
        if (this.activity == null || oldIndex != 0 || newIndex != 0) {
            throw new IndexOutOfBoundsException("could not reorder element: oldIndex=" + oldIndex + ", newIndex=" + newIndex);
        }
    }

    public List getNodes() {
        return this.activity != null ? Collections.singletonList(this.activity) : null;
    }

    public Node getNode(String name) {
        return this.hasNode(name) ? this.activity : null;
    }

    public Map getNodesMap() {
        return this.activity != null ? Collections.singletonMap(this.activity.getName(), this.activity) : null;
    }

    public boolean hasNode(String name) {
        return this.activity != null && this.activity.getName().equals(name);
    }

    protected boolean isChildInitial(Activity child) {
        return true;
    }

    public GraphElement getParent() {
        return this.isGlobal() ? this.processDefinition : super.getParent();
    }

    public ProcessDefinition getProcessDefinition() {
        return this.isGlobal() ? this.processDefinition : super.getProcessDefinition();
    }

    public BpelProcessDefinition getBpelProcessDefinition() {
        if (!this.isGlobal()) {
            return super.getBpelProcessDefinition();
        }
        if (this.processDefinition instanceof BpelProcessDefinition) {
            return (BpelProcessDefinition)this.processDefinition;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        BpelProcessDefinition bpelProcessDefinition = (BpelProcessDefinition)((Object)hbSession.load(BpelProcessDefinition.class, (Serializable)new Long(this.processDefinition.getId())));
        this.processDefinition = bpelProcessDefinition;
        return bpelProcessDefinition;
    }

    protected boolean suppressJoinFailure() {
        return this.isGlobal() ? this.getSuppressJoinFailure().booleanValue() : super.suppressJoinFailure();
    }

    public boolean isGlobal() {
        return this.getCompositeActivity() == null;
    }

    public Collection findNestedScopes() {
        NestedScopeFinder finder = new NestedScopeFinder();
        this.activity.accept(finder);
        return finder.getScopes();
    }

    public Scope findNestedScope(String name) {
        Iterator nestedScopeIt = this.findNestedScopes().iterator();
        while (nestedScopeIt.hasNext()) {
            Scope nestedScope = (Scope)((Object)nestedScopeIt.next());
            if (!nestedScope.getName().equals(name)) continue;
            return nestedScope;
        }
        return null;
    }

    public ScopeInstance createInstance(Token token) {
        ScopeInstance instance = new ScopeInstance(this, token);
        token.getProcessInstance().getContextInstance().createVariable(VARIABLE_NAME, (Object)instance, token);
        return instance;
    }

    public EventInstance createEventInstance(Token token) {
        EventInstance instance = new EventInstance(this, token);
        token.getProcessInstance().getContextInstance().createVariable(VARIABLE_NAME, (Object)instance, token);
        return instance;
    }

    public static ScopeInstance getInstance(Token token) {
        return (ScopeInstance)token.getProcessInstance().getContextInstance().getVariable(VARIABLE_NAME, token);
    }

    private static class NamedCatchPredicate
    implements Predicate {
        private final QName faultName;

        NamedCatchPredicate(QName faultName) {
            this.faultName = faultName;
        }

        public boolean evaluate(Object arg) {
            Catch catcher = (Catch)arg;
            return this.faultName.equals(catcher.getFaultName());
        }
    }
}

