/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.exe.Compensator;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.persistence.db.ScopeSession;
import org.jbpm.graph.exe.ExecutionContext;

public class CompensateScope
extends Activity
implements Compensator {
    private Scope target;
    private static final long serialVersionUID = 1L;

    public CompensateScope() {
    }

    public CompensateScope(String name) {
        super(name);
    }

    public Scope getTarget() {
        return this.target;
    }

    public void setTarget(Scope target) {
        this.target = target;
    }

    public void execute(ExecutionContext exeContext) {
        ScopeSession scopeSession = ScopeSession.getInstance(exeContext.getJbpmContext());
        ScopeInstance nestedScope = scopeSession.nextScopeToCompensate(exeContext.getProcessInstance(), this.target);
        if (nestedScope != null) {
            nestedScope.compensate(this);
        } else {
            this.leave(exeContext);
        }
    }

    public void scopeCompensated(ScopeInstance nestedInstance) {
        ScopeSession scopeSession = ScopeSession.getInstance(JbpmContext.getCurrentJbpmContext());
        ScopeInstance nextNestedInstance = scopeSession.nextScopeToCompensate(nestedInstance.getToken().getProcessInstance(), this.target);
        if (nextNestedInstance != null) {
            nextNestedInstance.compensate(this);
        } else {
            ScopeInstance enclosingInstance = nestedInstance.getParent();
            while (!this.equals(enclosingInstance.getHandlerToken().getNode())) {
                if ((enclosingInstance = enclosingInstance.getParent()) != null) continue;
                throw new IllegalStateException("could not find handler token: compensate=" + this + ", nestedScope=" + nestedInstance);
            }
            this.leave(new ExecutionContext(enclosingInstance.getHandlerToken()));
        }
    }
}

