/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.def;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.graph.exe.LinkInstance;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public class LinkDefinition
implements Serializable {
    long id;
    private String name;
    private Activity target;
    private Activity source;
    private Expression transitionCondition;
    private static final long serialVersionUID = 1L;

    public LinkDefinition() {
    }

    public LinkDefinition(String name) {
        this.setName(name);
    }

    public void determineStatus(Token token) {
        LinkInstance linkInstance = this.getInstance(token);
        if (this.transitionCondition == null) {
            linkInstance.statusDetermined(true);
        } else {
            try {
                linkInstance.statusDetermined(DatatypeUtil.toBoolean(this.transitionCondition.getEvaluator().evaluate(token)));
            }
            catch (BpelFaultException e) {
                linkInstance.setStatus(Boolean.FALSE);
                throw e;
            }
        }
    }

    public Expression getTransitionCondition() {
        return this.transitionCondition;
    }

    public void setTransitionCondition(Expression transitionCondition) {
        this.transitionCondition = transitionCondition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Activity getTarget() {
        return this.target;
    }

    void setTarget(Activity target) {
        this.target = target;
    }

    public Activity getSource() {
        return this.source;
    }

    void setSource(Activity source) {
        this.source = source;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("source", (Object)this.source).append("target", (Object)this.target).toString();
    }

    public LinkInstance getInstance(Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        return (LinkInstance)ci.getVariable(this.name, token);
    }

    public LinkInstance createInstance(Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        LinkInstance linkInstance = new LinkInstance(this);
        ci.createVariable(this.name, (Object)linkInstance, token);
        return linkInstance;
    }
}

