/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.def;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.def.LinkDefinition;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.sublang.def.JoinCondition;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public abstract class Activity
extends Node {
    private CompositeActivity compositeActivity;
    private Collection sources;
    private Collection targets;
    private JoinCondition joinCondition;
    private Boolean suppressJoinFailure;
    private boolean nameGenerated;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Activity() {
    }

    protected Activity(String name) {
        this.name = name;
    }

    public void accept(BpelVisitor visitor) {
    }

    public void setName(String name) {
        if (this.getParent() != null) {
            throw new IllegalStateException("this activity is already part of a composite");
        }
        this.name = name;
    }

    public boolean isNameGenerated() {
        return this.nameGenerated;
    }

    public void setNameGenerated(boolean nameGenerated) {
        this.nameGenerated = nameGenerated;
    }

    public void enter(ExecutionContext exeContext) {
        Token token = exeContext.getToken();
        token.setNode((Node)this);
        this.fireEvent("node-enter", exeContext);
        token.setNodeEnter(new Date());
        exeContext.setTransition(null);
        exeContext.setTransitionSource(null);
        try {
            if (this.targets != null && !this.targets.isEmpty()) {
                this.setTargetsToken(token);
                if (!this.areTargetsDetermined(token) || !this.evaluateJoinCondition(token)) {
                    return;
                }
            }
            this.execute(exeContext);
        }
        catch (BpelFaultException e) {
            this.raiseException((Throwable)((Object)e), exeContext);
        }
    }

    private void setTargetsToken(Token token) {
        Iterator targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            LinkDefinition target = (LinkDefinition)targetIt.next();
            target.getInstance(token).setTargetToken(token);
        }
    }

    private boolean areTargetsDetermined(Token token) {
        Iterator targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            LinkDefinition target = (LinkDefinition)targetIt.next();
            if (target.getInstance(token).getStatus() != null) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateJoinCondition(Token token) {
        if (this.joinCondition != null) {
            if (DatatypeUtil.toBoolean(this.joinCondition.getEvaluator().evaluate(token))) {
                return true;
            }
        } else {
            Iterator targetIt = this.targets.iterator();
            while (targetIt.hasNext()) {
                LinkDefinition target = (LinkDefinition)targetIt.next();
                Boolean status = target.getInstance(token).getStatus();
                if (!$assertionsDisabled && status == null) {
                    throw new AssertionError((Object)"link status not resolved");
                }
                if (!status.booleanValue()) continue;
                return true;
            }
        }
        if (!this.suppressJoinFailure()) {
            throw new BpelFaultException(BpelConstants.FAULT_JOIN_FAILURE);
        }
        this.skip(new ExecutionContext(token));
        return false;
    }

    public void leave(ExecutionContext exeContext) {
        Transition transition;
        Token token;
        if (this.sources != null && !this.sources.isEmpty()) {
            BpelFaultException sourceFault = null;
            token = exeContext.getToken();
            Iterator sourceIt = this.sources.iterator();
            while (sourceIt.hasNext()) {
                LinkDefinition source = (LinkDefinition)sourceIt.next();
                try {
                    source.determineStatus(token);
                    if (!token.hasEnded()) continue;
                    return;
                }
                catch (BpelFaultException fault) {
                    sourceFault = fault;
                }
            }
            if (sourceFault != null) {
                throw sourceFault;
            }
        }
        if ((transition = this.getDefaultLeavingTransition()) != null) {
            this.leave(exeContext, transition);
        } else {
            token = exeContext.getToken();
            Node node = token.getNode();
            if (node == null) {
                token.setNode((Node)this);
            } else if (!$assertionsDisabled && !this.equals(node)) {
                throw new AssertionError(node);
            }
            this.fireEvent("node-leave", exeContext);
            Scope.getInstance(token).completed();
        }
    }

    public GraphElement getParent() {
        return this.compositeActivity;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.compositeActivity.getProcessDefinition();
    }

    public void terminate(ExecutionContext exeContext) {
    }

    public void skip(ExecutionContext context) {
        this.eliminatePath(context.getToken());
        this.leave(context, this.getDefaultLeavingTransition());
    }

    public void eliminatePath(Token token) {
        if (this.targets != null && !this.targets.isEmpty()) {
            this.setTargetsToken(token);
            if (!this.areTargetsDetermined(token)) {
                return;
            }
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            this.setNegativeSourcesStatus(token);
        }
    }

    private void setNegativeSourcesStatus(Token token) {
        Iterator sourceIt = this.sources.iterator();
        while (sourceIt.hasNext()) {
            LinkDefinition source = (LinkDefinition)sourceIt.next();
            source.getInstance(token).statusDetermined(false);
        }
    }

    public void targetDetermined(Token token) {
        if (!this.areTargetsDetermined(token)) {
            return;
        }
        try {
            if (!this.equals(token.getNode())) {
                this.setNegativeSourcesStatus(token);
            } else if (this.evaluateJoinCondition(token)) {
                this.execute(new ExecutionContext(token));
            }
        }
        catch (BpelFaultException e) {
            this.raiseException((Throwable)((Object)e), new ExecutionContext(token));
        }
    }

    protected boolean suppressJoinFailure() {
        return this.suppressJoinFailure != null ? this.suppressJoinFailure.booleanValue() : this.getCompositeActivity().suppressJoinFailure();
    }

    public JoinCondition getJoinCondition() {
        return this.joinCondition;
    }

    public void setJoinCondition(JoinCondition joinCondition) {
        this.joinCondition = joinCondition;
    }

    public Boolean getSuppressJoinFailure() {
        return this.suppressJoinFailure;
    }

    public void setSuppressJoinFailure(Boolean suppressJoinFailure) {
        this.suppressJoinFailure = suppressJoinFailure;
    }

    public LinkDefinition getTarget(String name) {
        if (this.targets != null) {
            Iterator targetIt = this.targets.iterator();
            while (targetIt.hasNext()) {
                LinkDefinition target = (LinkDefinition)targetIt.next();
                if (!name.equals(target.getName())) continue;
                return target;
            }
        }
        return null;
    }

    public Collection getTargets() {
        return this.targets;
    }

    public void addTarget(LinkDefinition link) {
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (this.targets == null) {
            this.targets = new HashSet();
        }
        this.targets.add(link);
        link.setTarget(this);
    }

    public void removeTarget(LinkDefinition link) {
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (this.targets != null && this.targets.remove(link)) {
            link.setTarget(null);
        }
    }

    public LinkDefinition getSource(String name) {
        if (this.sources != null) {
            Iterator sourceIt = this.sources.iterator();
            while (sourceIt.hasNext()) {
                LinkDefinition source = (LinkDefinition)sourceIt.next();
                if (!name.equals(source.getName())) continue;
                return source;
            }
        }
        return null;
    }

    public Collection getSources() {
        return this.sources;
    }

    public void addSource(LinkDefinition link) {
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (this.sources == null) {
            this.sources = new HashSet();
        }
        this.sources.add(link);
        link.setSource(this);
    }

    public void removeSource(LinkDefinition link) {
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (this.sources != null && this.sources.remove(link)) {
            link.setSource(null);
        }
    }

    public CompositeActivity getCompositeActivity() {
        return this.compositeActivity;
    }

    void setCompositeActivity(CompositeActivity compositeActivity) {
        this.compositeActivity = compositeActivity;
    }

    public void detachFromParent() {
        if (this.compositeActivity != null) {
            this.compositeActivity.removeNode(this);
            this.compositeActivity = null;
        }
    }

    public BpelProcessDefinition getBpelProcessDefinition() {
        return (BpelProcessDefinition)this.getProcessDefinition();
    }

    public Scope getScope() {
        if (!this.compositeActivity.isScope()) {
            return this.compositeActivity.getScope();
        }
        if (this.compositeActivity instanceof Scope) {
            return (Scope)this.compositeActivity;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        Scope scope = (Scope)((Object)hbSession.load(Scope.class, (Serializable)new Long(this.compositeActivity.getId())));
        this.compositeActivity = scope;
        return scope;
    }

    public Transition getDefaultArrivingTransition() {
        return (Transition)this.getArrivingTransitions().iterator().next();
    }

    public boolean isInitial() {
        return (this.compositeActivity == null || this.compositeActivity.isInitial() && this.compositeActivity.isChildInitial(this)) && (this.targets == null || this.targets.isEmpty());
    }

    public void connect(Node to) {
        Transition transition = new Transition();
        transition.setName(this.getName() + '-' + to.getName());
        transition.setProcessDefinition(this.processDefinition);
        this.addLeavingTransition(transition);
        to.addArrivingTransition(transition);
    }

    public boolean isConnected(Node to) {
        if (this.leavingTransitions != null) {
            Iterator transitionIt = this.leavingTransitions.iterator();
            while (transitionIt.hasNext()) {
                Transition transition = (Transition)transitionIt.next();
                if (!to.equals((Object)transition.getTo())) continue;
                return true;
            }
        }
        return false;
    }

    public void disconnect(Node to) {
        if (this.leavingTransitions != null) {
            Iterator transitionIt = this.leavingTransitions.iterator();
            while (transitionIt.hasNext()) {
                Transition transition = (Transition)transitionIt.next();
                if (!to.equals((Object)transition.getTo())) continue;
                transitionIt.remove();
                to.removeArrivingTransition(transition);
                break;
            }
        }
    }

    static {
        $assertionsDisabled = !Activity.class.desiredAssertionStatus();
    }
}

