/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSet12Byte
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter12Byte";
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;

    CharacterSet12Byte(int n, CharacterConverters characterConverters) {
        super(n, characterConverters);
    }

    static CharacterSet12Byte getInstance(int n, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 1) {
            return new CharacterSet12Byte(n, characterConverters);
        }
        return null;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n = n << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = 0;
        int n3 = 1;
        while (n >> n2 != 0) {
            n2 = (short)(n2 + 8);
            n3 = (short)(n3 + 1);
        }
        CharacterSet12Byte.need(characterBuffer, n3);
        while (n2 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> n2 & 0xFF);
            n2 = (short)(n2 - 8);
        }
    }
}

