/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.HelpActionMarker;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JTabbedFormDialog;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class SwingXFormDialogBuilder
extends XFormDialogBuilder {
    private String name;
    private SwingXFormDialog dialog;

    public SwingXFormDialogBuilder(String name) {
        this.name = name;
    }

    public XForm createForm(String name) {
        SwingXFormImpl form = new SwingXFormImpl(name);
        this.addForm(form);
        return form;
    }

    public XFormDialog buildDialog(ActionList actions, String description, ImageIcon icon) {
        XForm[] forms = this.getForms();
        this.dialog = forms.length > 1 ? new JTabbedFormDialog(this.name, forms, actions, description, icon) : new JFormDialog(this.name, forms[0], actions, description, icon);
        return this.dialog;
    }

    public ActionList buildOkCancelActions() {
        DefaultActionList actions = new DefaultActionList("Actions");
        actions.addAction(new OKAction());
        actions.addAction(new CancelAction());
        return actions;
    }

    public ActionList buildOkCancelHelpActions(String url) {
        DefaultActionList actions = new DefaultActionList("Actions");
        actions.addAction(new HelpAction(url));
        actions.addAction(new OKAction());
        actions.addAction(new CancelAction());
        return actions;
    }

    public final class HelpAction
    extends AbstractAction
    implements HelpActionMarker {
        private final String url;

        public HelpAction(String url) {
            this("Online Help", url, UISupport.getKeyStroke("F1"));
        }

        public HelpAction(String title, String url) {
            this(title, url, null);
        }

        public HelpAction(String title, String url, KeyStroke accelerator) {
            super(title);
            this.url = url;
            this.putValue("ShortDescription", "Show online help");
            if (accelerator != null) {
                this.putValue("AcceleratorKey", accelerator);
            }
            this.putValue("SmallIcon", UISupport.HELP_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            Tools.openURL(this.url);
        }
    }

    protected final class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            if (SwingXFormDialogBuilder.this.dialog != null) {
                SwingXFormDialogBuilder.this.dialog.setReturnValue(2);
                SwingXFormDialogBuilder.this.dialog.setVisible(false);
            }
        }
    }

    protected final class OKAction
    extends AbstractAction {
        public OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent e) {
            if (SwingXFormDialogBuilder.this.dialog != null) {
                SwingXFormDialogBuilder.this.dialog.setReturnValue(1);
                SwingXFormDialogBuilder.this.dialog.setVisible(false);
            }
        }
    }
}

