/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class JFormDialog
extends SwingXFormDialog {
    private JDialog dialog;
    private SwingXFormImpl form;

    public JFormDialog(String name, XForm form, ActionList actions, String description, ImageIcon icon) {
        this.dialog = new JDialog(UISupport.getMainFrame(), name, true);
        JButtonBar buttons = UISupport.initDialogActions(actions, this.dialog);
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel panel = new JPanel(new BorderLayout());
        this.form = (SwingXFormImpl)form;
        panel.add((Component)this.form.getPanel(), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (description != null || icon != null) {
            this.dialog.getContentPane().add(UISupport.buildDescription(name, description, icon), "North");
        }
        this.dialog.getContentPane().add((Component)panel, "Center");
        buttons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.WHITE)), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        this.dialog.getContentPane().add((Component)buttons, "South");
    }

    public void setValues(StringToStringMap values) {
        this.form.setValues(values);
    }

    public StringToStringMap getValues() {
        StringToStringMap result = new StringToStringMap();
        result.putAll(this.form.getValues());
        return result;
    }

    public void setOptions(String field, Object[] options) {
        this.form.setOptions(field, options);
    }

    public void setVisible(boolean visible) {
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        if (size.getHeight() < 270.0) {
            this.dialog.setSize(new Dimension((int)size.getWidth(), 270));
        }
        UISupport.centerDialog(this.dialog);
        this.dialog.setVisible(visible);
    }

    public boolean validate() {
        XFormField[] formFields = this.form.getFormFields();
        for (int c = 0; c < formFields.length; ++c) {
            ValidationMessage[] messages = formFields[c].validate();
            if (messages == null || messages.length <= 0) continue;
            ((JComponent)((AbstractSwingXFormField)messages[0].getFormField()).getComponent()).requestFocus();
            UISupport.showErrorMessage(messages[0].getMessage());
            return false;
        }
        return true;
    }

    public void setFormFieldProperty(String name, Object value) {
        this.form.setFormFieldProperty(name, value);
    }

    public String getValue(String field) {
        return this.form.getComponentValue(field);
    }

    public void setValue(String field, String value) {
        this.form.setComponentValue(field, value);
    }

    public int getValueIndex(String name) {
        String[] options = this.form.getOptions(name);
        if (options == null) {
            return -1;
        }
        return Arrays.asList(options).indexOf(this.form.getComponentValue(name));
    }

    public boolean show() {
        this.show(new StringToStringMap());
        return this.getReturnValue() == 1;
    }

    public XFormField getFormField(String name) {
        return this.form.getFormField(name);
    }
}

