/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.actions;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FindAndReplaceDialog
extends AbstractAction {
    private final FindAndReplaceable target;
    private JDialog dialog;
    private JCheckBox caseCheck;
    private JRadioButton allButton;
    private JRadioButton selectedLinesButton;
    private JRadioButton forwardButton;
    private JRadioButton backwardButton;
    private JCheckBox wholeWordCheck;
    private JButton findButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JComboBox findCombo;
    private JComboBox replaceCombo;
    private JCheckBox wrapCheck;

    public FindAndReplaceDialog(FindAndReplaceable target) {
        super("Find / Replace");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("F3"));
        this.target = target;
    }

    public void actionPerformed(ActionEvent e) {
        this.show();
    }

    public void show() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.replaceCombo.setEnabled(this.target.isEditable());
        this.replaceAllButton.setEnabled(this.target.isEditable());
        this.replaceButton.setEnabled(this.target.isEditable());
        UISupport.showDialog(this.dialog);
        this.findCombo.getEditor().selectAll();
        this.findCombo.requestFocus();
    }

    private void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame(), "Find / Replace", false);
        JPanel panel = new JPanel(new BorderLayout());
        this.findCombo = new JComboBox();
        this.findCombo.setEditable(true);
        this.replaceCombo = new JComboBox();
        this.replaceCombo.setEditable(true);
        GridLayout gridLayout = new GridLayout(2, 2);
        gridLayout.setVgap(5);
        JPanel inputPanel = new JPanel(gridLayout);
        inputPanel.add(new JLabel("Find:"));
        inputPanel.add(this.findCombo);
        inputPanel.add(new JLabel("Replace with:"));
        inputPanel.add(this.replaceCombo);
        inputPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        ButtonGroup directionGroup = new ButtonGroup();
        this.forwardButton = new JRadioButton("Forward", true);
        this.forwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.forwardButton);
        this.backwardButton = new JRadioButton("Backward");
        this.backwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.backwardButton);
        JPanel directionPanel = new JPanel(new GridLayout(2, 1));
        directionPanel.add(this.forwardButton);
        directionPanel.add(this.backwardButton);
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        ButtonGroup scopeGroup = new ButtonGroup();
        this.allButton = new JRadioButton("All", true);
        this.allButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectedLinesButton = new JRadioButton("Selected Lines");
        this.selectedLinesButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        scopeGroup.add(this.allButton);
        scopeGroup.add(this.selectedLinesButton);
        JPanel scopePanel = new JPanel(new GridLayout(2, 1));
        scopePanel.add(this.allButton);
        scopePanel.add(this.selectedLinesButton);
        scopePanel.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.caseCheck = new JCheckBox("Case Sensitive");
        this.caseCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wholeWordCheck = new JCheckBox("Whole Word");
        this.wholeWordCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wrapCheck = new JCheckBox("Wrap Search");
        this.wrapCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel optionsPanel = new JPanel(new GridLayout(3, 1));
        optionsPanel.add(this.caseCheck);
        optionsPanel.add(this.wholeWordCheck);
        optionsPanel.add(this.wrapCheck);
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        JPanel options = new JPanel(new GridLayout(1, 2));
        JPanel radios = new JPanel(new GridLayout(2, 1));
        radios.add(directionPanel);
        radios.add(scopePanel);
        options.add(optionsPanel);
        options.add(radios);
        options.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.findButton = new JButton(new FindAction());
        builder.addFixed((JComponent)this.findButton);
        builder.addRelatedGap();
        this.replaceButton = new JButton(new ReplaceAction());
        builder.addFixed((JComponent)this.replaceButton);
        builder.addRelatedGap();
        this.replaceAllButton = new JButton(new ReplaceAllAction());
        builder.addFixed((JComponent)this.replaceAllButton);
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JButton(new CloseAction()));
        builder.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.add((Component)inputPanel, "North");
        panel.add((Component)options, "Center");
        panel.add((Component)builder.getPanel(), "South");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.getRootPane().setDefaultButton(this.findButton);
    }

    private int findNext(int pos, String txt, String value) {
        int ix;
        int n = ix = this.forwardButton.isSelected() ? txt.indexOf(value, pos + 1) : txt.lastIndexOf(value, pos - 1);
        if (this.wholeWordCheck.isSelected()) {
            while (ix != -1 && ix > 0 && Character.isLetterOrDigit(txt.charAt(ix - 1)) || ix < txt.length() - value.length() - 1 && Character.isLetterOrDigit(txt.charAt(ix + value.length()))) {
                ix = this.findNext(ix, txt, value);
            }
        }
        if (ix == -1 && this.wrapCheck.isSelected()) {
            if (this.forwardButton.isSelected() && pos > 0) {
                return this.findNext(0, txt, value);
            }
            if (this.backwardButton.isSelected() && pos < txt.length() - 1) {
                return this.findNext(txt.length() - 1, txt, value);
            }
        }
        if (this.selectedLinesButton.isSelected() && (ix < this.target.getSelectionStart() || ix > this.target.getSelectionEnd())) {
            ix = -1;
        }
        return ix;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            FindAndReplaceDialog.this.dialog.setVisible(false);
        }
    }

    private class ReplaceAllAction
    extends AbstractAction {
        public ReplaceAllAction() {
            super("Replace All");
        }

        public void actionPerformed(ActionEvent e) {
            int valueInNewValueIx;
            int ix;
            int pos = FindAndReplaceDialog.this.target.getCaretPosition();
            String txt = FindAndReplaceDialog.this.target.getText();
            String value = FindAndReplaceDialog.this.findCombo.getSelectedItem().toString();
            if (value.length() == 0 || txt.length() == 0) {
                return;
            }
            String newValue = FindAndReplaceDialog.this.replaceCombo.getSelectedItem().toString();
            if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                if (newValue.equalsIgnoreCase(value)) {
                    return;
                }
                value = value.toUpperCase();
                txt = txt.toUpperCase();
            } else if (newValue.equals(value)) {
                return;
            }
            int firstIx = ix = FindAndReplaceDialog.this.findNext(pos, txt, value);
            int n = valueInNewValueIx = !FindAndReplaceDialog.this.caseCheck.isSelected() ? newValue.toUpperCase().indexOf(value) : newValue.indexOf(value);
            while (ix != -1) {
                System.out.println("found match at " + ix + ", " + firstIx + ", " + valueInNewValueIx);
                FindAndReplaceDialog.this.target.select(ix + value.length(), ix);
                FindAndReplaceDialog.this.target.setSelectedText(newValue);
                FindAndReplaceDialog.this.target.select(ix + newValue.length(), ix);
                if (ix < firstIx) {
                    firstIx += newValue.length() - value.length();
                }
                txt = FindAndReplaceDialog.this.target.getText();
                if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                    txt = txt.toUpperCase();
                }
                ix = FindAndReplaceDialog.this.findNext(ix + newValue.length(), txt, value);
                if (!FindAndReplaceDialog.this.wrapCheck.isSelected() || valueInNewValueIx == -1 || ix != firstIx + valueInNewValueIx) continue;
                break;
            }
        }
    }

    private class ReplaceAction
    extends AbstractAction {
        public ReplaceAction() {
            super("Replace");
        }

        public void actionPerformed(ActionEvent e) {
            if (FindAndReplaceDialog.this.target.getSelectedText() == null) {
                return;
            }
            String value = FindAndReplaceDialog.this.replaceCombo.getSelectedItem().toString();
            int ix = FindAndReplaceDialog.this.target.getSelectionStart();
            FindAndReplaceDialog.this.target.setSelectedText(value);
            FindAndReplaceDialog.this.target.select(ix + value.length(), ix);
            for (int c = 0; c < FindAndReplaceDialog.this.replaceCombo.getItemCount(); ++c) {
                if (!FindAndReplaceDialog.this.replaceCombo.getItemAt(c).equals(value)) continue;
                FindAndReplaceDialog.this.replaceCombo.removeItem(c);
                break;
            }
            FindAndReplaceDialog.this.replaceCombo.insertItemAt(value, 0);
        }
    }

    private class FindAction
    extends AbstractAction {
        public FindAction() {
            super("Find");
        }

        public void actionPerformed(ActionEvent e) {
            int ix;
            int pos = FindAndReplaceDialog.this.target.getCaretPosition();
            int selstart = FindAndReplaceDialog.this.target.getSelectionStart();
            if (selstart < pos && selstart != -1) {
                pos = selstart;
            }
            String txt = FindAndReplaceDialog.this.target.getText();
            String value = FindAndReplaceDialog.this.findCombo.getSelectedItem().toString();
            if (value.length() == 0 || pos == txt.length()) {
                return;
            }
            if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                value = value.toUpperCase();
                txt = txt.toUpperCase();
            }
            if ((ix = FindAndReplaceDialog.this.findNext(pos, txt, value)) != -1) {
                FindAndReplaceDialog.this.target.select(ix, ix + value.length());
                for (int c = 0; c < FindAndReplaceDialog.this.findCombo.getItemCount(); ++c) {
                    if (!FindAndReplaceDialog.this.findCombo.getItemAt(c).equals(value)) continue;
                    FindAndReplaceDialog.this.findCombo.removeItem(c);
                    break;
                }
                FindAndReplaceDialog.this.findCombo.insertItemAt(value, 0);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

