/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class ShowRequestStepResultsAction
extends AbstractAction {
    private final WsdlTestRequestStepResult result;
    private DefaultDesktopPanel desktopPanel;

    public ShowRequestStepResultsAction(WsdlTestStepResult result) {
        super("Show Results");
        this.result = (WsdlTestRequestStepResult)result;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.result.isDiscarded()) {
                UISupport.showInfoMessage("Request has been discarded..");
            } else {
                UISupport.showDesktopPanel(this.buildFrame());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new DefaultDesktopPanel("TestStep Result", "TestStep result for " + this.result.getTestStep().getName(), this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JTabbedPane messageTabs = new JTabbedPane();
        messageTabs.addTab("Request Properties", this.buildPropertiesTab());
        messageTabs.addTab("Request Message", this.buildRequestTab());
        messageTabs.addTab("Response Message", this.buildResponseTab());
        messageTabs.setPreferredSize(new Dimension(500, 400));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UISupport.createTabPanel(messageTabs, true), "Center");
        return panel;
    }

    private Component buildPropertiesTab() {
        String[] messages;
        JPropertiesTable<WsdlTestRequestStepResult> table = new JPropertiesTable<WsdlTestRequestStepResult>("Result Properties", this.result);
        table.addProperty("Status", "status");
        table.addProperty("Time Taken", "timeTaken");
        table.addProperty("Size", "size");
        table.addProperty("Timestamp", "timeStamp", false, new TimestampPropertyFormatter());
        table.addProperty("TestStep", "testStep", false, new TestStepPropertyFormatter());
        table.addProperty("Encoding", "encoding");
        table.addProperty("Endpoint", "endpoint");
        table.addProperty("Username", "username");
        table.addProperty("Password", "password");
        table.addProperty("Domain", "domain");
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        JList messageList = new JList(listModel);
        for (String message : messages = this.result.getMessages()) {
            listModel.addElement(message);
        }
        JSplitPane split = UISupport.createVerticalSplit(table, new JScrollPane(messageList));
        split.setDividerLocation(200);
        return split;
    }

    private Component buildResponseTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        WsdlResponse response = this.result.getResponse();
        if (response != null) {
            resultArea.setText(XmlUtils.prettyPrintXml(response.getContentAsString()));
        } else {
            resultArea.setText("- null -");
        }
        resultArea.setEditable(false);
        resultArea.setToolTipText("Response Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        return scrollPane;
    }

    private Component buildRequestTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        String requestContent = this.result.getRequestContent();
        if (requestContent != null) {
            resultArea.setText(XmlUtils.prettyPrintXml(requestContent));
        } else {
            resultArea.setText("- null -");
        }
        resultArea.setEditable(false);
        resultArea.setToolTipText("Request Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        return scrollPane;
    }

    private static final class TimestampPropertyFormatter
    implements JPropertiesTable.PropertyFormatter {
        private TimestampPropertyFormatter() {
        }

        public Object format(String propertyName, Object value) {
            return new Date(Long.valueOf(value.toString()));
        }
    }

    private static final class TestStepPropertyFormatter
    implements JPropertiesTable.PropertyFormatter {
        private TestStepPropertyFormatter() {
        }

        public Object format(String propertyName, Object value) {
            return ((TestStep)value).getName();
        }
    }
}

