/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.xsd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaException;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.Tools;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtils {
    private static final Logger log = Logger.getLogger(SchemaUtils.class);
    private static Map<String, XmlObject> defaultSchemas = new HashMap<String, XmlObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultSchemas() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SoapUI.class.getClassLoader());
        try {
            defaultSchemas.clear();
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/xop.xsd"));
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/XMLSchema.xsd"));
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/xml.xsd"));
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/swaref.xsd"));
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/xmime200505.xsd"));
            SchemaUtils.loadDefaultSchema(SoapUI.class.getResource("/xmime200411.xsd"));
            String schemaDirectory = SoapUI.getSchemaDirectory();
            if (schemaDirectory != null && schemaDirectory.trim().length() > 0) {
                SchemaUtils.loadSchemaDirectory(schemaDirectory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static void loadSchemaDirectory(String schemaDirectory) throws IOException, MalformedURLException {
        File dir = new File(schemaDirectory);
        if (dir.exists() && dir.isDirectory()) {
            String[] xsdFiles = dir.list();
            int cnt = 0;
            if (xsdFiles != null && xsdFiles.length > 0) {
                for (int c = 0; c < xsdFiles.length; ++c) {
                    try {
                        String xsdFile = xsdFiles[c];
                        if (!xsdFile.endsWith(".xsd")) continue;
                        String filename = schemaDirectory + File.separator + xsdFile;
                        SchemaUtils.loadDefaultSchema(new URL("file:" + filename));
                        ++cnt;
                        continue;
                    }
                    catch (XmlException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (cnt == 0) {
                log.warn((Object)("Missing schema files in  schemaDirectory [" + schemaDirectory + "]"));
            }
        } else {
            log.warn((Object)("Failed to open schemaDirectory [" + schemaDirectory + "]"));
        }
    }

    private static void loadDefaultSchema(URL url) throws XmlException, IOException {
        XmlObject xmlObject = XmlObject.Factory.parse((URL)url);
        String targetNamespace = SchemaUtils.getTargetNamespace(xmlObject);
        if (defaultSchemas.containsKey(targetNamespace)) {
            log.warn((Object)("Overriding schema for targetNamespace " + targetNamespace));
        }
        defaultSchemas.put(targetNamespace, xmlObject);
        log.info((Object)("Added default schema from " + url.getPath() + " with targetNamespace " + targetNamespace));
    }

    public static SchemaTypeLoader loadSchemaTypes(String wsdlUrl, SoapVersion soapVersion, WsdlLoader loader) throws SchemaException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SoapUI.class.getClassLoader());
        try {
            log.info((Object)("Loading schema types from [" + wsdlUrl + "]"));
            ArrayList<XmlObject> schemas = new ArrayList<XmlObject>(SchemaUtils.getSchemas(wsdlUrl, loader).values());
            SchemaTypeLoader schemaTypeLoader = SchemaUtils.buildSchemaTypes(schemas, soapVersion);
            return schemaTypeLoader;
        }
        catch (Exception e) {
            throw new SchemaException("Error loading schema types", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static SchemaTypeLoader buildSchemaTypes(List<XmlObject> schemas, SoapVersion soapVersion) throws SchemaException {
        XmlOptions options = new XmlOptions();
        options.setCompileNoValidation();
        options.setCompileNoPvrRule();
        options.setCompileDownloadUrls();
        options.setCompileNoUpaRule();
        options.setValidateTreatLaxAsSkip();
        ArrayList errorList = new ArrayList();
        options.setErrorListener(errorList);
        try {
            for (int c = 0; c < schemas.size(); ++c) {
                XmlObject s = schemas.get(c);
                HashMap map = new HashMap();
                XmlCursor cursor = s.newCursor();
                cursor.toStartDoc();
                if (SchemaUtils.toNextContainer(cursor)) {
                    cursor.getAllNamespaces(map);
                } else {
                    log.warn((Object)("Can not get namespaces for " + s));
                }
                String tns = SchemaUtils.getTargetNamespace(s);
                log.info((Object)("schema for [" + tns + "] contained [" + ((Object)map).toString() + "] namespaces"));
                if (defaultSchemas.containsKey(tns) || tns.equals(SchemaUtils.getTargetNamespace(soapVersion.getSoapEncodingSchema())) || tns.equals(SchemaUtils.getTargetNamespace(soapVersion.getSoapEnvelopeSchema()))) {
                    schemas.remove(c);
                    --c;
                    continue;
                }
                SchemaUtils.removeImports(s);
            }
            schemas.add(soapVersion.getSoapEncodingSchema());
            schemas.add(soapVersion.getSoapEnvelopeSchema());
            schemas.addAll(defaultSchemas.values());
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])schemas.toArray(new XmlObject[schemas.size()]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)options);
            SchemaTypeLoader schemaTypeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{sts, XmlBeans.getBuiltinTypeSystem()});
            return schemaTypeLoader;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaException(e, errorList);
        }
        finally {
            for (int c = 0; c < errorList.size(); ++c) {
                log.warn((Object)("Error: " + errorList.get(c)));
            }
        }
    }

    public static boolean toNextContainer(XmlCursor cursor) {
        while (!cursor.isContainer() && !cursor.isEnddoc()) {
            cursor.toNextToken();
        }
        return cursor.isContainer();
    }

    public static String getTargetNamespace(XmlObject s) {
        return ((Document)s.getDomNode()).getDocumentElement().getAttribute("targetNamespace");
    }

    public static Map<String, XmlObject> getSchemas(String wsdlUrl, WsdlLoader loader) throws SchemaException {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        SchemaUtils.getSchemas(wsdlUrl, result, loader);
        return result;
    }

    public static void getSchemas(String wsdlUrl, Map<String, XmlObject> existing, WsdlLoader loader) throws SchemaException {
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        log.info((Object)("Getting schema " + wsdlUrl));
        ArrayList errorList = new ArrayList();
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        try {
            XmlObject[] schemas;
            XmlOptions options = new XmlOptions();
            options.setCompileNoValidation();
            options.setSaveUseOpenFrag();
            options.setErrorListener(errorList);
            options.setSaveSyntheticDocumentElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, options);
            Document dom = (Document)xmlObject.getDomNode();
            Element domNode = dom.getDocumentElement();
            if (domNode.getLocalName().equals("schema") && domNode.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                result.put(wsdlUrl, xmlObject);
            } else {
                schemas = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:schema");
                for (int i = 0; i < schemas.length; ++i) {
                    XmlCursor xmlCursor = schemas[i].newCursor();
                    String xmlText = xmlCursor.getObject().xmlText(options);
                    schemas[i] = XmlObject.Factory.parse((String)xmlText, (XmlOptions)options);
                    schemas[i].documentProperties().setSourceName(wsdlUrl);
                    result.put(wsdlUrl + "@" + (i + 1), schemas[i]);
                }
                XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
                for (int i = 0; i < wsdlImports.length; ++i) {
                    String location = ((SimpleValue)wsdlImports[i]).getStringValue();
                    if (location == null) continue;
                    if (location.startsWith("file:") || location.indexOf("://") > 0) {
                        SchemaUtils.getSchemas(location, existing, loader);
                        continue;
                    }
                    SchemaUtils.getSchemas(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
                }
            }
            existing.putAll(result);
            schemas = result.values().toArray(new XmlObject[result.size()]);
            for (int c = 0; c < schemas.length; ++c) {
                xmlObject = schemas[c];
                XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
                for (int i = 0; i < schemaImports.length; ++i) {
                    String location = ((SimpleValue)schemaImports[i]).getStringValue();
                    if (location == null) continue;
                    if (location.startsWith("file:") || location.indexOf("://") > 0) {
                        SchemaUtils.getSchemas(location, existing, loader);
                        continue;
                    }
                    SchemaUtils.getSchemas(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
                }
                XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
                for (int i = 0; i < schemaIncludes.length; ++i) {
                    String location = ((SimpleValue)schemaIncludes[i]).getStringValue();
                    if (location == null) continue;
                    if (location.startsWith("file:") || location.indexOf("://") > 0) {
                        SchemaUtils.getSchemas(location, existing, loader);
                        continue;
                    }
                    SchemaUtils.getSchemas(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaException(e, errorList);
        }
    }

    public static Map<String, XmlObject> getDefinitionParts(WsdlLoader loader) throws Exception {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        SchemaUtils.getDefinitionParts(loader.getBaseURI(), result, loader);
        return result;
    }

    public static void getDefinitionParts(String wsdlUrl, Map<String, XmlObject> existing, WsdlLoader loader) throws Exception {
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, null);
        existing.put(wsdlUrl, xmlObject);
        XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import");
        for (int i = 0; i < wsdlImports.length; ++i) {
            String location = wsdlImports[i].getDomNode().getAttributes().getNamedItem("location").getNodeValue();
            if (location == null) continue;
            if (location.startsWith("file:") || location.indexOf("://") > 0) {
                SchemaUtils.getDefinitionParts(location, existing, loader);
                continue;
            }
            SchemaUtils.getDefinitionParts(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
        }
        XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
        for (int i = 0; i < schemaImports.length; ++i) {
            String location = ((SimpleValue)schemaImports[i]).getStringValue();
            if (location == null) continue;
            if (location.startsWith("file:") || location.indexOf("://") > 0) {
                SchemaUtils.getDefinitionParts(location, existing, loader);
                continue;
            }
            SchemaUtils.getDefinitionParts(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
        }
        XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
        for (int i = 0; i < schemaIncludes.length; ++i) {
            String location = ((SimpleValue)schemaIncludes[i]).getStringValue();
            if (location == null) continue;
            if (location.startsWith("file:") || location.indexOf("://") > 0) {
                SchemaUtils.getDefinitionParts(location, existing, loader);
                continue;
            }
            SchemaUtils.getDefinitionParts(Tools.joinRelativeUrl(wsdlUrl, location), existing, loader);
        }
    }

    public static Collection<String> extractNamespaces(SchemaTypeSystem schemaTypes) {
        HashSet<String> namespaces = new HashSet<String>();
        SchemaType[] globalTypes = schemaTypes.globalTypes();
        for (int c = 0; c < globalTypes.length; ++c) {
            namespaces.add(globalTypes[c].getName().getNamespaceURI());
        }
        namespaces.remove("http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.remove("http://schemas.xmlsoap.org/soap/encoding/");
        return namespaces;
    }

    public static void removeImports(XmlObject xmlObject) throws XmlException {
        XmlObject[] imports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import");
        for (int c = 0; c < imports.length; ++c) {
            XmlCursor cursor = imports[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
        XmlObject[] includes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include");
        for (int c = 0; c < includes.length; ++c) {
            XmlCursor cursor = includes[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
    }

    public static boolean isInstanceOf(SchemaType schemaType, SchemaType baseType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(baseType) ? true : SchemaUtils.isInstanceOf(schemaType.getBaseType(), baseType);
    }

    public static boolean isBinaryType(SchemaType schemaType) {
        return SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type) || SchemaUtils.isInstanceOf(schemaType, XmlBase64Binary.type);
    }

    public static String getDocumentation(SchemaParticle particle, SchemaType schemaType) {
        XmlObject[] userInformation;
        XmlObject[] userInformation2;
        SchemaAnnotation annotation;
        String result = null;
        if (particle instanceof SchemaLocalElement && (annotation = ((SchemaLocalElement)particle).getAnnotation()) != null && (userInformation2 = annotation.getUserInformation()) != null && userInformation2.length > 0) {
            result = userInformation2[0].toString();
        }
        if (schemaType != null && schemaType.getAnnotation() != null && (userInformation = schemaType.getAnnotation().getUserInformation()) != null && userInformation.length > 0) {
            result = userInformation[0].toString();
        }
        if (result != null) {
            result = result.replaceAll("<br/>", "\n");
            StringTokenizer st = new StringTokenizer(result, "\r\n");
            StringBuffer buf = new StringBuffer("<html><body>");
            boolean added = false;
            while (st.hasMoreElements()) {
                String str;
                if (added) {
                    buf.append("<br>");
                }
                if ((str = st.nextToken().trim()).length() <= 0) continue;
                buf.append(str);
                added = true;
            }
            buf.append("</body></html>");
            result = buf.toString();
        }
        return result;
    }

    public static String[] getEnumerationValues(SchemaType schemaType, boolean addNull) {
        XmlAnySimpleType[] enumerationValues;
        if (schemaType != null && (enumerationValues = schemaType.getEnumerationValues()) != null && enumerationValues.length > 0) {
            if (addNull) {
                String[] values = new String[enumerationValues.length + 1];
                values[0] = null;
                for (int c = 1; c < values.length; ++c) {
                    values[c] = enumerationValues[c - 1].getStringValue();
                }
                return values;
            }
            String[] values = new String[enumerationValues.length];
            for (int c = 0; c < values.length; ++c) {
                values[c] = enumerationValues[c].getStringValue();
            }
            return values;
        }
        return new String[0];
    }

    static {
        SchemaUtils.initDefaultSchemas();
        SoapUI.getSettings().addSettingsListener(new SettingsListener(){

            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(WsdlSettings.SCHEMA_DIRECTORY)) {
                    log.info((Object)"Reloading default schemas..");
                    SchemaUtils.initDefaultSchemas();
                }
            }
        });
    }
}

