/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor.inspectors;

import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlInspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractXmlInspector
implements XmlInspector {
    private final PropertyChangeSupport propertySupport;
    private String title;
    private String description;
    private boolean enabled;
    private XmlEditor editor;

    protected AbstractXmlInspector(String title, String description, boolean enabled) {
        this.title = title;
        this.description = description;
        this.enabled = enabled;
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.propertySupport.firePropertyChange(DESCRIPTION_PROPERTY, oldDescription, description);
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertySupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertySupport.firePropertyChange(ENABLED_PROPERTY, oldEnabled, enabled);
    }

    public void init(XmlEditor editor) {
        this.editor = editor;
    }

    public XmlEditor getEditor() {
        return this.editor;
    }
}

