/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.mock.ListMouseListener;
import com.eviware.soapui.impl.wsdl.panels.mock.ModelItemListMouseListener;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.support.MockRunListenerAdapter;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockServiceDesktopPanel
extends ModelItemDesktopPanel<WsdlMockService> {
    private static final String LOG_TITLE = "Request Log";
    private JButton runButton;
    private MockRunner mockRunner;
    private JButton stopButton;
    private JProgressBar progressBar;
    private DefaultListModel logListModel;
    private JList testLogList;
    private JCheckBox enableLogCheckBox;
    private JScrollPane logScrollPane;
    private JList operationList;
    private InternalMockRunListener mockRunListener;
    private JTextField pathTextField;
    private JTextField portTextField;

    public WsdlMockServiceDesktopPanel(WsdlMockService mockService) {
        super(mockService);
        this.buildUI();
        this.setPreferredSize(new Dimension(350, 500));
        this.mockRunListener = new InternalMockRunListener();
        mockService.addMockRunListener(this.mockRunListener);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.mockRunner != null && canCancel && !UISupport.confirm("Close and stop MockService", "Close MockService")) {
            return false;
        }
        if (this.mockRunner != null) {
            this.mockRunner.stop();
        }
        ((WsdlMockService)this.getModelItem()).removeMockRunListener(this.mockRunListener);
        ((OperationListModel)this.operationList.getModel()).release();
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockService)this.getModelItem()).getProject();
    }

    private void buildUI() {
        this.add(this.buildToolbar(), "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        splitPane.setTopComponent(this.buildOperationList());
        splitPane.setBottomComponent(this.buildLog());
        splitPane.setDividerLocation(0.7);
        splitPane.setDividerLocation(250);
        this.add((Component)splitPane, "Center");
        this.add((Component)new JLabel("--"), "Last");
    }

    public boolean logIsEnabled() {
        return this.enableLogCheckBox.isSelected();
    }

    private Component buildOperationList() {
        JPanel panel = new JPanel(new BorderLayout());
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.enableLogCheckBox = new JCheckBox("Enable Log", true);
        this.enableLogCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WsdlMockServiceDesktopPanel.this.testLogList.setEnabled(WsdlMockServiceDesktopPanel.this.enableLogCheckBox.isSelected());
                WsdlMockServiceDesktopPanel.this.logScrollPane.repaint();
            }
        });
        builder.addFixed((JComponent)this.enableLogCheckBox);
        builder.addGlue();
        this.progressBar = new JProgressBar();
        JPanel progressBarPanel = UISupport.createProgressBarPanel(this.progressBar, 2, false);
        progressBarPanel.setPreferredSize(new Dimension(60, 20));
        builder.addFixed((JComponent)progressBarPanel);
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        panel.add((Component)builder.getPanel(), "North");
        this.operationList = new JList(new OperationListModel());
        this.operationList.addMouseListener(new ModelItemListMouseListener());
        this.operationList.setCellRenderer(new OperationListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.operationList);
        UISupport.addTitledBorder(scrollPane, "Operations");
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private Component buildLog() {
        this.logListModel = new DefaultListModel();
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new LogCellRenderer());
        this.testLogList.setPrototypeCellValue("Testing 123");
        this.testLogList.setFixedCellWidth(-1);
        this.testLogList.addMouseListener(new LogListMouseListener());
        this.testLogList.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.logScrollPane = new JScrollPane(this.testLogList);
        this.logScrollPane.setBorder(null);
        UISupport.addTitledBorder(this.logScrollPane, LOG_TITLE);
        return this.logScrollPane;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = this.createActionButton(new RunMockServiceAction(), true);
        this.stopButton = this.createActionButton(new StopMockServiceAction(), false);
        toolbar.addFixed(this.runButton);
        toolbar.addFixed(this.stopButton);
        toolbar.addUnrelatedGap();
        this.pathTextField = new JTextField(15);
        this.pathTextField.setToolTipText("The URL path to listen on for this service");
        this.pathTextField.setText(((WsdlMockService)this.getModelItem()).getPath());
        this.pathTextField.setCaretPosition(0);
        this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setPath(WsdlMockServiceDesktopPanel.this.pathTextField.getText());
            }
        });
        toolbar.addLabeledFixed("Path:", this.pathTextField);
        toolbar.addUnrelatedGap();
        this.portTextField = new JTextField(5);
        this.portTextField.setToolTipText("The local port to listen on for this service");
        this.portTextField.setText(String.valueOf(((WsdlMockService)this.getModelItem()).getPort()));
        this.portTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                try {
                    ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setPort(Integer.parseInt(WsdlMockServiceDesktopPanel.this.portTextField.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        toolbar.addLabeledFixed("Port:", this.portTextField);
        toolbar.addGlue();
        toolbar.addFixed(this.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/services.html"), true));
        return toolbar;
    }

    private final class LogListMouseListener
    extends ListMouseListener {
        private LogListMouseListener() {
        }

        protected ActionList getActionsForRow(JList list, int row) {
            MockResult result = (MockResult)WsdlMockServiceDesktopPanel.this.logListModel.getElementAt(row);
            return result == null ? null : result.getActions();
        }
    }

    private static final class LogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public LogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                this.setText(value.toString());
            } else if (value instanceof MockResult) {
                MockResult result = (MockResult)value;
                String msg = this.dateFormat.format(new Date(result.getTimestamp()));
                MockResponse mockResponse = result.getMockResponse();
                if (mockResponse == null) {
                    msg = msg + ": [dispatch error; missing response]";
                } else {
                    msg = msg + ": [" + mockResponse.getMockOperation().getName();
                    msg = msg + "] " + result.getTimeTaken() + "ms";
                }
                this.setText(msg);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    public class StopMockServiceAction
    extends AbstractAction {
        public StopMockServiceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.gif"));
            this.putValue("ShortDescription", "Stops this MockService on the specified port and endpoint");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WsdlMockServiceDesktopPanel.this.mockRunner == null) {
                UISupport.showErrorMessage("MockService is not running");
            } else {
                WsdlMockServiceDesktopPanel.this.mockRunner.stop();
                WsdlMockServiceDesktopPanel.this.mockRunner = null;
            }
            WsdlMockServiceDesktopPanel.this.progressBar.setIndeterminate(false);
            WsdlMockServiceDesktopPanel.this.runButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.stopButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.pathTextField.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.portTextField.setEnabled(true);
        }
    }

    public class RunMockServiceAction
    extends AbstractAction {
        public RunMockServiceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Starts this MockService on the specified port and endpoint");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WsdlMockServiceDesktopPanel.this.mockRunner != null || SoapUI.getMockEngine().hasRunningMock((MockService)WsdlMockServiceDesktopPanel.this.getModelItem())) {
                UISupport.showErrorMessage("MockService is already running");
            } else {
                try {
                    WsdlMockServiceDesktopPanel.this.mockRunner = ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).start();
                }
                catch (Exception e) {
                    UISupport.showErrorMessage(e);
                    e.printStackTrace();
                    return;
                }
            }
            WsdlMockServiceDesktopPanel.this.progressBar.setIndeterminate(true);
            WsdlMockServiceDesktopPanel.this.runButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.stopButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.pathTextField.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.portTextField.setEnabled(false);
        }
    }

    private static final class OperationListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private OperationListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MockOperation testStep = (MockOperation)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            return this;
        }
    }

    public class OperationListModel
    extends AbstractListModel
    implements ListModel,
    MockServiceListener,
    PropertyChangeListener {
        private List<WsdlMockOperation> operations = new ArrayList<WsdlMockOperation>();

        public OperationListModel() {
            for (int c = 0; c < ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getMockOperationCount(); ++c) {
                WsdlMockOperation mockOperation = ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getMockOperationAt(c);
                mockOperation.addPropertyChangeListener(this);
                this.operations.add(mockOperation);
            }
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).addMockServiceListener(this);
        }

        public Object getElementAt(int arg0) {
            return this.operations.get(arg0);
        }

        public int getSize() {
            return this.operations.size();
        }

        public void mockOperationAdded(MockOperation operation) {
            this.operations.add((WsdlMockOperation)operation);
            operation.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.operations.size() - 1, this.operations.size() - 1);
        }

        public void mockOperationRemoved(MockOperation operation) {
            int ix = this.operations.indexOf(operation);
            this.operations.remove(ix);
            operation.removePropertyChangeListener(this);
            this.fireIntervalRemoved(this, ix, ix);
        }

        public void mockResponseAdded(MockResponse request) {
        }

        public void mockResponseRemoved(MockResponse request) {
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(WsdlMockOperation.NAME_PROPERTY)) {
                int ix = this.operations.indexOf(arg0.getSource());
                this.fireContentsChanged(this, ix, ix);
            }
        }

        public void release() {
            for (WsdlMockOperation operation : this.operations) {
                operation.removePropertyChangeListener(this);
            }
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).removeMockServiceListener(this);
        }
    }

    private final class InternalMockRunListener
    extends MockRunListenerAdapter {
        private InternalMockRunListener() {
        }

        public void onMockResult(MockResult result) {
            if (WsdlMockServiceDesktopPanel.this.logIsEnabled()) {
                WsdlMockServiceDesktopPanel.this.logListModel.addElement(result);
            }
        }
    }
}

