/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RemoveTestSuiteAction
extends AbstractAction {
    private final WsdlTestSuite testSuite;

    public RemoveTestSuiteAction(WsdlTestSuite testSuite) {
        super("Remove");
        this.testSuite = testSuite;
        this.putValue("ShortDescription", "Removes this TestSuite from the project");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        for (int c = 0; c < this.testSuite.getTestCaseCount(); ++c) {
            if (!SoapUI.getTestMonitor().hasRunningTest(this.testSuite.getTestCaseAt(c))) continue;
            UISupport.showErrorMessage("Cannot remove testSuite due to running tests");
            return;
        }
        if (UISupport.confirm("Remove TestSuite [" + this.testSuite.getName() + "] from project", "Remove TestSuite")) {
            this.testSuite.getProject().removeTestSuite(this.testSuite);
        }
    }
}

