/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ClearTestCaseAction
extends AbstractAction {
    private final WsdlTestCase testCase;

    public ClearTestCaseAction(WsdlTestCase testCase) {
        super("Clear");
        this.testCase = testCase;
        this.putValue("ShortDescription", "Clears this TestCase");
    }

    public void actionPerformed(ActionEvent e) {
        if (SoapUI.getTestMonitor().hasRunningTest(this.testCase)) {
            UISupport.showErrorMessage("Cannot clear TestCase while tests are running");
        } else if (UISupport.confirm("Remove all TestSteps and LoadTests from this TestCase?", "Clear TestCase")) {
            while (this.testCase.getLoadTestCount() > 0) {
                this.testCase.removeLoadTest(this.testCase.getLoadTestAt(0));
            }
            while (this.testCase.getTestStepCount() > 0) {
                this.testCase.removeTestStep(this.testCase.getTestStepAt(0));
            }
        }
    }
}

