/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockoperation;

import com.eviware.soapui.config.DispatchStyleConfig;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.AbstractSwingAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockOperationOptionsAction
extends AbstractSwingAction<WsdlMockOperation> {
    private XFormDialog dialog;
    private DefineNamespacesAction defineNamespacesAction;
    private WsdlProject project;

    public WsdlMockOperationOptionsAction(WsdlMockOperation mockOperation) {
        super("MockOperation Options", "Sets options for this MockOperation", mockOperation);
        this.project = mockOperation.getMockService().getProject();
    }

    @Override
    public void actionPerformed(ActionEvent arg0, WsdlMockOperation mockOperation) {
        if (this.dialog == null) {
            DefaultActionList actions = new DefaultActionList();
            this.defineNamespacesAction = new DefineNamespacesAction(mockOperation);
            actions.addAction(this.defineNamespacesAction);
            this.dialog = ADialogBuilder.buildDialog(Form.class, actions);
            this.dialog.getFormField("Dispatch Style").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    boolean enabled = newValue.equals("XPATH") || newValue.equals("SCRIPT");
                    WsdlMockOperationOptionsAction.this.enableXPathFields(enabled);
                    WsdlMockOperationOptionsAction.this.defineNamespacesAction.setEnabled(enabled);
                }
            });
            this.dialog.getFormField("Interface").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    WsdlInterface iface = WsdlMockOperationOptionsAction.this.project.getInterfaceByName(newValue);
                    WsdlMockOperationOptionsAction.this.dialog.setOptions("Operation", new ModelItemNames<Operation>(iface.getOperations()).getNames());
                }
            });
        }
        ArrayList<WsdlInterface> interfaces = new ArrayList<WsdlInterface>();
        for (int c = 0; c < this.project.getInterfaceCount(); ++c) {
            if (this.project.getInterfaceAt(c).getOperationCount() <= 0) continue;
            interfaces.add(this.project.getInterfaceAt(c));
        }
        this.dialog.setOptions("Interface", new ModelItemNames(interfaces).getNames());
        this.dialog.setOptions("Operation", new ModelItemNames<Operation>(((Interface)interfaces.get(0)).getOperations()).getNames());
        this.dialog.setValue("Interface", mockOperation.getOperation().getInterface().getName());
        this.dialog.setValue("Operation", mockOperation.getOperation().getName());
        this.dialog.setOptions("Default Response", new ModelItemNames<MockResponse>(mockOperation.getMockResponses()).getNames());
        this.dialog.setValue("Dispatch Style", mockOperation.getDispatchStyle().toString());
        this.dialog.setValue("Dispatch Path", mockOperation.getDispatchPath());
        this.dialog.setValue("Default Response", mockOperation.getDefaultResponse());
        this.enableXPathFields(this.dialog.getValue("Dispatch Style").equals("XPATH") || this.dialog.getValue("Dispatch Style").equals("SCRIPT"));
        if (this.dialog.show()) {
            mockOperation.setDispatchStyle(DispatchStyleConfig.Enum.forString((String)this.dialog.getValue("Dispatch Style")));
            mockOperation.setDispatchPath(this.dialog.getValue("Dispatch Path"));
            mockOperation.setDefaultResponse(this.dialog.getValue("Default Response"));
            WsdlOperation operation = this.project.getInterfaceByName(this.dialog.getValue("Interface")).getOperationByName(this.dialog.getValue("Operation"));
            if (operation != mockOperation.getOperation()) {
                mockOperation.setOperation(operation);
            }
        }
    }

    private void enableXPathFields(boolean enabled) {
        this.dialog.getFormField("Dispatch Path").setEnabled(enabled);
        this.dialog.getFormField("Default Response").setEnabled(enabled);
        this.defineNamespacesAction.setEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefineNamespacesAction
    extends AbstractSwingAction<WsdlMockOperation> {
        public DefineNamespacesAction(WsdlMockOperation mockOperation) {
            super("Define Namespaces", "Defines namespaces from last Mock Request", mockOperation);
        }

        @Override
        public void actionPerformed(ActionEvent arg0, WsdlMockOperation mockOperation) {
            WsdlMockResult result = mockOperation.getLastMockResult();
            if (result == null || result.getMockRequest() == null) {
                UISupport.showErrorMessage("Missing request to define from");
            } else {
                try {
                    String ns = XmlUtils.declareXPathNamespaces(result.getMockRequest().getRequestContent());
                    if (ns != null) {
                        ns = ns + WsdlMockOperationOptionsAction.this.dialog.getValue("Dispatch Path");
                        WsdlMockOperationOptionsAction.this.dialog.setValue("Dispatch Path", ns);
                    }
                }
                catch (XmlException e) {
                    UISupport.showErrorMessage((Exception)((Object)e));
                }
            }
        }
    }

    @AForm(description="Set options for this MockOperation", name="MockOperation Options")
    private class Form {
        @AField(description="Specifies the operation to be mocked", name="Operation", type=AField.AFieldType.ENUMERATION)
        public static final String OPERATION = "Operation";
        @AField(description="Specifies the interface containing the operation to be mocked", name="Interface", type=AField.AFieldType.ENUMERATION)
        public static final String INTERFACE = "Interface";
        @AField(description="How to dispatch requests to responses", name="Dispatch Style", type=AField.AFieldType.ENUMERATION, values={"SEQUENCE", "RANDOM", "XPATH", "SCRIPT"})
        public static final String DISPATCH_STYLE = "Dispatch Style";
        @AField(description="The XPath to use for selecting the corresponding response", name="Dispatch Path", type=AField.AFieldType.STRINGAREA)
        public static final String DISPATCH_PATH = "Dispatch Path";
        @AField(description="Default response to use", name="Default Response", type=AField.AFieldType.ENUMERATION)
        public static final String DEFAULT_RESPONSE = "Default Response";

        private Form() {
        }
    }
}

