/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.EndpointConfig;
import com.eviware.soapui.config.EndpointsConfig;
import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.SoapVersionTypesConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.iface.ExportDefinitionAction;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateTestSuiteAction;
import com.eviware.soapui.impl.wsdl.actions.iface.InterfaceEndpointsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.RemoveInterfaceAction;
import com.eviware.soapui.impl.wsdl.actions.iface.UpdateInterfaceAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis1.Axis1XWSDL2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis2.Axis2WSDL2CodeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.dotnet.DotNetWsdlAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.gsoap.GSoapAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jaxb.JaxbXjcAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.JBossWSConsumeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsRegenerateJava2WsdlAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsWsdl2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.oracle.OracleWsaGenProxyAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.tcpmon.TcpMonAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wscompile.WSCompileAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIAnalyzeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsimport.WSImportAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xfire.XFireAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xmlbeans.XmlBeans2Action;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.CachedWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.InterfaceListener;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionExtensionPoint;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.types.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlInterface
extends AbstractWsdlModelItem<InterfaceConfig>
implements Interface {
    public static final String STYLE_DOCUMENT = "Document";
    public static final String STYLE_RPC = "RPC";
    public static final String JBOSSWS_ACTIONS = "jbossws";
    public static final String WSTOOLS_ACTIONS = "wstools";
    public static final String XML_ACTIONS = "xml";
    private static final Logger log = Logger.getLogger(WsdlInterface.class);
    private List<WsdlOperation> operations = new ArrayList<WsdlOperation>();
    private WsdlProject project;
    private SoapMessageBuilder soapMessageBuilder;
    private WsdlContext wsdlContext;
    private Set<InterfaceListener> listeners = new HashSet<InterfaceListener>();
    private DefaultActionList generateActions;

    public WsdlInterface(WsdlProject project, InterfaceConfig interfaceConfig) {
        super(interfaceConfig, project, "/interface2.gif");
        this.project = project;
        if (interfaceConfig.getEndpoints() == null) {
            interfaceConfig.addNewEndpoints();
        }
        List operationConfigs = interfaceConfig.getOperationList();
        for (int i = 0; i < operationConfigs.size(); ++i) {
            this.operations.add(new WsdlOperation(this, (OperationConfig)operationConfigs.get(i)));
        }
        this.buildActions();
    }

    private void buildActions() {
        this.generateActions = new DefaultActionList("Generate");
        this.generateActions.addAction(new ActionExtensionPoint(this, WSTOOLS_ACTIONS));
        this.generateActions.addAction(new WSToolsWsdl2JavaAction(this));
        this.generateActions.addAction(new JBossWSConsumeAction(this));
        this.generateActions.addAction(ActionSupport.SEPARATOR_ACTION);
        this.generateActions.addAction(new ActionExtensionPoint(this, JBOSSWS_ACTIONS));
        this.generateActions.addAction(new WSCompileAction(this));
        this.generateActions.addAction(new WSImportAction(this));
        this.generateActions.addAction(ActionSupport.SEPARATOR_ACTION);
        this.generateActions.addAction(new Axis1XWSDL2JavaAction(this));
        this.generateActions.addAction(new Axis2WSDL2CodeAction(this));
        this.generateActions.addAction(new XFireAction(this));
        this.generateActions.addAction(new OracleWsaGenProxyAction(this));
        this.generateActions.addAction(ActionSupport.SEPARATOR_ACTION);
        this.generateActions.addAction(new ActionExtensionPoint(this, XML_ACTIONS));
        this.generateActions.addAction(new JaxbXjcAction(this));
        this.generateActions.addAction(new XmlBeans2Action(this));
        this.generateActions.addAction(ActionSupport.SEPARATOR_ACTION);
        this.generateActions.addAction(new DotNetWsdlAction(this));
        this.generateActions.addAction(new GSoapAction(this));
        this.addAction(new ShowDesktopPanelAction("Open Interface Viewer", "Opens the Interface Viewer for this Interface", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ActionSupport.ActionListAction(this.generateActions));
        this.addAction(new WSToolsRegenerateJava2WsdlAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new WSIAnalyzeAction(this));
        this.addAction(new TcpMonAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new GenerateTestSuiteAction(this));
        this.addAction(new GenerateMockServiceAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new InterfaceEndpointsAction(this));
        this.addAction(new UpdateInterfaceAction(this));
        this.addAction(new ExportDefinitionAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RemoveInterfaceAction(this));
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/interfaces.html"));
    }

    public DefaultActionList getGenerateActions() {
        return this.generateActions;
    }

    @Override
    public String[] getEndpoints() {
        EndpointsConfig endpoints = ((InterfaceConfig)this.getConfig()).getEndpoints();
        List endpointArray = endpoints.getEndpointList();
        String[] result = new String[endpointArray.size()];
        for (int c = 0; c < result.length; ++c) {
            EndpointConfig endpoint = (EndpointConfig)endpointArray.get(c);
            result[c] = endpoint.isSetLabel() ? endpoint.getLabel() : endpoint.getStringValue();
        }
        return result;
    }

    @Override
    public WsdlOperation getOperationAt(int index) {
        return this.operations.get(index);
    }

    @Override
    public int getOperationCount() {
        return this.operations.size();
    }

    public WsdlOperation addNewOperation(BindingOperation operation) {
        WsdlOperation operationImpl = new WsdlOperation(this, ((InterfaceConfig)this.getConfig()).addNewOperation());
        this.operations.add(operationImpl);
        operationImpl.initFromBindingOperation(operation, false);
        this.fireOperationAdded(operationImpl);
        return operationImpl;
    }

    @Override
    public WsdlProject getProject() {
        return this.project;
    }

    @Override
    public void addEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().length() == 0) {
            return;
        }
        endpoint = endpoint.trim();
        String[] endpoints = this.getEndpoints();
        if (Arrays.asList(endpoints).contains(endpoint)) {
            return;
        }
        ((InterfaceConfig)this.getConfig()).getEndpoints().addNewEndpoint().setStringValue(endpoint);
        this.notifyPropertyChanged(ENDPOINT_PROPERTY, null, endpoint);
    }

    @Override
    public void changeEndpoint(String oldEndpoint, String newEndpoint) {
        if (oldEndpoint == null || oldEndpoint.trim().length() == 0) {
            return;
        }
        if (newEndpoint == null || newEndpoint.trim().length() == 0) {
            return;
        }
        EndpointsConfig endpoints = ((InterfaceConfig)this.getConfig()).getEndpoints();
        List endpointArray = endpoints.getEndpointList();
        String[] result = new String[endpointArray.size()];
        for (int c = 0; c < result.length; ++c) {
            EndpointConfig endpoint = (EndpointConfig)endpointArray.get(c);
            if (!endpoint.getStringValue().equals(oldEndpoint)) continue;
            endpoint.setStringValue(newEndpoint);
            this.notifyPropertyChanged(ENDPOINT_PROPERTY, oldEndpoint, newEndpoint);
            break;
        }
    }

    @Override
    public void removeEndpoint(String endpoint) {
        EndpointsConfig endpoints = ((InterfaceConfig)this.getConfig()).getEndpoints();
        List endpointArray = endpoints.getEndpointList();
        String[] result = new String[endpointArray.size()];
        for (int c = 0; c < result.length; ++c) {
            EndpointConfig ep = (EndpointConfig)endpointArray.get(c);
            if (!ep.getStringValue().equals(endpoint)) continue;
            endpoints.removeEndpoint(c);
            this.notifyPropertyChanged(ENDPOINT_PROPERTY, endpoint, null);
            break;
        }
    }

    public void setDefinition(String wsdlUrl, boolean cache) {
        String old = this.getDefinition();
        ((InterfaceConfig)this.getConfig()).setDefinition(wsdlUrl);
        if (this.wsdlContext != null) {
            this.wsdlContext.setDefinition(wsdlUrl, ((InterfaceConfig)this.getConfig()).getDefinitionCache());
            this.wsdlContext.setSoapVersion(this.getSoapVersion());
        }
        this.notifyPropertyChanged(DEFINITION_PROPERTY, old, wsdlUrl);
    }

    public DefinitionCacheConfig cacheDefinition(WsdlLoader loader) throws Exception {
        log.debug((Object)("Caching definition for [" + loader.getBaseURI() + "]"));
        if (((InterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((InterfaceConfig)this.getConfig()).unsetDefinitionCache();
        }
        DefinitionCacheConfig definitionCache = ((InterfaceConfig)this.getConfig()).addNewDefinitionCache();
        definitionCache.set((XmlObject)WsdlLoader.cacheWsdl(loader));
        return definitionCache;
    }

    @Override
    public String getDefinition() {
        return ((InterfaceConfig)this.getConfig()).isSetDefinition() ? ((InterfaceConfig)this.getConfig()).getDefinition() : null;
    }

    @Override
    public synchronized WsdlContext getWsdlContext() {
        if (this.wsdlContext == null) {
            this.wsdlContext = new WsdlContext(this.getDefinition(), this.getSoapVersion(), ((InterfaceConfig)this.getConfig()).getDefinitionCache(), this);
        }
        return this.wsdlContext;
    }

    public void setWsdlContext(WsdlContext wsdlContext) {
        this.wsdlContext = wsdlContext;
        this.wsdlContext.setSoapVersion(this.getSoapVersion());
        if (!((InterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((InterfaceConfig)this.getConfig()).addNewDefinitionCache();
        }
        if (wsdlContext.getCacheConfig() != null) {
            ((InterfaceConfig)this.getConfig()).setDefinitionCache(wsdlContext.getCacheConfig());
        }
    }

    @Override
    public SoapMessageBuilder getMessageBuilder() {
        if (this.soapMessageBuilder == null) {
            try {
                this.soapMessageBuilder = new SoapMessageBuilder(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.soapMessageBuilder;
    }

    public void setSoapMessageBuilder(SoapMessageBuilder builder) {
        this.soapMessageBuilder = builder;
        this.soapMessageBuilder.setInterface(this);
    }

    @Override
    public QName getBindingName() {
        return ((InterfaceConfig)this.getConfig()).getBindingName() == null ? null : QName.valueOf(((InterfaceConfig)this.getConfig()).getBindingName());
    }

    public void setBindingName(QName name) {
        ((InterfaceConfig)this.getConfig()).setBindingName(name.toString());
    }

    public SoapVersion getSoapVersion() {
        if (((InterfaceConfig)this.getConfig()).getSoapVersion() == SoapVersionTypesConfig.X_1_2) {
            return SoapVersion.Soap12;
        }
        return SoapVersion.Soap11;
    }

    public void setSoapVersion(SoapVersion version) {
        if (version == SoapVersion.Soap11) {
            ((InterfaceConfig)this.getConfig()).setSoapVersion(SoapVersionTypesConfig.X_1_1);
        } else if (version == SoapVersion.Soap12) {
            ((InterfaceConfig)this.getConfig()).setSoapVersion(SoapVersionTypesConfig.X_1_2);
        } else {
            throw new RuntimeException("Unknown soapVersion [" + version + "], must be 1.1 or 1.2");
        }
        this.getWsdlContext().setSoapVersion(version);
    }

    public boolean updateDefinition(String url, boolean createRequests) throws Exception {
        String endpoint;
        StringList list;
        BindingOperation newOperation;
        int c;
        WsdlContext newContext = null;
        if (((InterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((InterfaceConfig)this.getConfig()).unsetDefinitionCache();
        }
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            newContext = new WsdlContext(url, this.getSoapVersion(), null, null);
            newContext.load();
        } else {
            newContext = new WsdlContext(url, this.getSoapVersion(), null, this);
        }
        Definition definition = newContext.getDefinition();
        Service service = null;
        Port port = null;
        Binding binding = null;
        Map serviceMap = definition.getAllServices();
        Iterator i = serviceMap.keySet().iterator();
        while (i.hasNext()) {
            service = (Service)serviceMap.get(i.next());
            Map portMap = service.getPorts();
            Iterator i2 = portMap.keySet().iterator();
            while (i2.hasNext()) {
                port = (Port)portMap.get(i2.next());
                if (!port.getBinding().getQName().equals(this.getBindingName())) continue;
                binding = port.getBinding();
            }
            if (binding != null) break;
            service = null;
        }
        if (service == null && binding == null) {
            binding = definition.getBinding(this.getBindingName());
        }
        if (binding == null) {
            Map bindings = definition.getAllBindings();
            Object retval = UISupport.prompt("Missing matching binding [" + this.getBindingName() + "] in definition, select new\nbinding to map to", "Map Binding", bindings.keySet().toArray());
            if (retval == null) {
                return false;
            }
            binding = (Binding)bindings.get(retval);
            this.setBindingName(binding.getQName());
        }
        if (this.getSettings().getBoolean(WsdlSettings.NAME_WITH_BINDING)) {
            this.setName(binding.getQName().getLocalPart());
        }
        ArrayList newOperations = new ArrayList(binding.getBindingOperations());
        HashMap<String, WsdlOperation> oldOperations = new HashMap<String, WsdlOperation>();
        for (c = 0; c < this.operations.size(); ++c) {
            oldOperations.put(this.operations.get(c).getBindingOperationName(), this.operations.get(c));
        }
        for (c = 0; c < newOperations.size(); ++c) {
            newOperation = (BindingOperation)newOperations.get(c);
            String bindingOperationName = newOperation.getName();
            if (!oldOperations.containsKey(bindingOperationName)) continue;
            log.info((Object)("Synchronizing existing operation [" + bindingOperationName + "]"));
            WsdlOperation wsdlOperation = (WsdlOperation)oldOperations.get(bindingOperationName);
            wsdlOperation.initFromBindingOperation(newOperation, true);
            oldOperations.remove(bindingOperationName);
            newOperations.remove(c);
            --c;
        }
        i = oldOperations.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (newOperations.size() > 0) {
                list = new ArrayList();
                list.add("none - delete operation");
                for (int c2 = 0; c2 < newOperations.size(); ++c2) {
                    list.add(((BindingOperation)newOperations.get(c2)).getName());
                }
                String retval = (String)UISupport.prompt("Binding operation [" + name + "] not found in new interface, select new\nbinding operation to map to", "Map Operation", list.toArray(), "none - delete operation");
                if (retval == null) {
                    UISupport.showErrorMessage("Aborting update of interface");
                    return false;
                }
                int ix = list.indexOf(retval) - 1;
                if (ix < 0) {
                    this.deleteOperation(name);
                } else {
                    BindingOperation newOperation2 = (BindingOperation)newOperations.get(ix);
                    WsdlOperation wsdlOperation = (WsdlOperation)oldOperations.get(name);
                    wsdlOperation.initFromBindingOperation(newOperation2, true);
                    newOperations.remove(ix);
                }
                oldOperations.remove(name);
            } else {
                this.deleteOperation(name);
                oldOperations.remove(name);
            }
            i = oldOperations.keySet().iterator();
        }
        this.wsdlContext = newContext;
        if (this.soapMessageBuilder != null) {
            this.soapMessageBuilder.setWsdlContext(this.wsdlContext);
        }
        if (newOperations.size() > 0) {
            for (c = 0; c < newOperations.size(); ++c) {
                newOperation = (BindingOperation)newOperations.get(c);
                WsdlOperation wsdlOperation = this.addNewOperation(newOperation);
                if (!createRequests) continue;
                WsdlRequest request = wsdlOperation.addNewRequest("Request 1");
                try {
                    request.setRequestContent(wsdlOperation.createRequest(true));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.setDefinition(url, false);
        if (port != null && (endpoint = WsdlUtils.getSoapEndpoint(port)) != null && !(list = new StringList(this.getEndpoints())).contains(endpoint)) {
            if (UISupport.confirm("Update existing requests with new endpoint\n[" + endpoint + "]", "Update Definition")) {
                for (int c3 = 0; c3 < this.getOperationCount(); ++c3) {
                    WsdlOperation operation = this.getOperationAt(c3);
                    for (int ix = 0; ix < operation.getRequestCount(); ++ix) {
                        operation.getRequestAt(ix).setEndpoint(endpoint);
                    }
                }
            }
            ((InterfaceConfig)this.getConfig()).getEndpoints().insertNewEndpoint(0).setStringValue(endpoint);
            this.notifyPropertyChanged(ENDPOINT_PROPERTY, null, endpoint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOperation(String bindingOperationName) {
        for (int c = 0; c < this.operations.size(); ++c) {
            WsdlOperation wsdlOperation = this.operations.get(c);
            if (!wsdlOperation.getBindingOperationName().equals(bindingOperationName)) continue;
            log.info((Object)("deleting operation [" + bindingOperationName + "]"));
            while (wsdlOperation.getRequestCount() > 0) {
                wsdlOperation.removeRequest(wsdlOperation.getRequestAt(0));
            }
            this.operations.remove(c);
            try {
                this.fireOperationRemoved(wsdlOperation);
            }
            finally {
                wsdlOperation.release();
                ((InterfaceConfig)this.getConfig()).removeOperation(c);
            }
            return;
        }
    }

    public void fireOperationAdded(WsdlOperation operation) {
        InterfaceListener[] a = this.listeners.toArray(new InterfaceListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationAdded(operation);
        }
    }

    public void fireOperationUpdated(WsdlOperation operation) {
        InterfaceListener[] a = this.listeners.toArray(new InterfaceListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationUpdated(operation);
        }
    }

    public void fireOperationRemoved(WsdlOperation operation) {
        InterfaceListener[] a = this.listeners.toArray(new InterfaceListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationRemoved(operation);
        }
    }

    public void fireRequestAdded(WsdlRequest request) {
        InterfaceListener[] a = this.listeners.toArray(new InterfaceListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].requestAdded(request);
        }
    }

    public void fireRequestRemoved(WsdlRequest request) {
        InterfaceListener[] a = this.listeners.toArray(new InterfaceListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].requestRemoved(request);
        }
    }

    @Override
    public void addInterfaceListener(InterfaceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeInterfaceListener(InterfaceListener listener) {
        this.listeners.remove(listener);
    }

    public String getEndpointURL(String endpoint) {
        List endpointArray = ((InterfaceConfig)this.getConfig()).getEndpoints().getEndpointList();
        for (EndpointConfig endpointConfig : endpointArray) {
            if (!endpointConfig.isSetLabel() || !endpointConfig.getLabel().equals(endpoint)) continue;
            return endpointConfig.getStringValue();
        }
        return endpoint;
    }

    @Override
    public WsdlOperation getOperationByName(String name) {
        return (WsdlOperation)this.getWsdlModelItemByName(this.operations, name);
    }

    @Override
    public boolean isCached() {
        return ((InterfaceConfig)this.getConfig()).isSetDefinitionCache();
    }

    @Override
    public WsdlLoader createWsdlLoader() {
        return this.isCached() ? new CachedWsdlLoader(((InterfaceConfig)this.getConfig()).getDefinitionCache()) : new UrlWsdlLoader(this.getDefinition());
    }

    public void clearCache() {
        if (this.wsdlContext != null) {
            this.wsdlContext.setDefinitionCache(null);
        }
        if (((InterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((InterfaceConfig)this.getConfig()).unsetDefinitionCache();
        }
    }

    public String getStyle() {
        if (this.wsdlContext == null || !this.wsdlContext.isLoaded()) {
            return "<not loaded>";
        }
        try {
            Binding binding = this.wsdlContext.getDefinition().getBinding(this.getBindingName());
            if (binding == null) {
                return "<missing binding>";
            }
            if (WsdlUtils.isRpc(binding)) {
                return STYLE_RPC;
            }
            return STYLE_DOCUMENT;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<error>";
        }
    }

    @Override
    public void release() {
        super.release();
        for (WsdlOperation operation : this.operations) {
            operation.release();
        }
    }

    @Override
    public List<Operation> getOperations() {
        return new ArrayList<Operation>(this.operations);
    }
}

