/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.config.SoapuiSettingsDocumentConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis1.Axis1XWSDL2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis2.Axis2WSDL2CodeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.dotnet.DotNetWsdlAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.gsoap.GSoapAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jaxb.JaxbXjcAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.JBossWSConsumeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsWsdl2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.oracle.OracleWsaGenProxyAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.SwingToolHost;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.tcpmon.TcpMonAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wscompile.WSCompileAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsimport.WSImportAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xfire.XFireAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xmlbeans.XmlBeans2Action;
import com.eviware.soapui.impl.wsdl.actions.support.OpenUrlAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceFactory;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.ClasspathHacker;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.log.Log4JMonitor;
import com.eviware.soapui.support.log.LogDisablingTestMonitorListener;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.ui.JDesktopPanelsList;
import com.eviware.soapui.ui.Navigator;
import com.eviware.soapui.ui.NavigatorListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.DesktopRegistry;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.soapui.ui.desktop.standalone.StandaloneDesktop;
import com.eviware.soapui.ui.desktop.standalone.StandaloneDesktopFactory;
import com.eviware.soapui.ui.support.DesktopListenerAdapter;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.impl.swing.SwingFormFactory;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUI {
    public static final Logger log = Logger.getLogger(SoapUI.class);
    public static final String SOAPUI_VERSION = "1.7.1";
    public static final String DEFAULT_WORKSPACE_FILE = "default-soapui-workspace.xml";
    private static final String DEFAULT_SETTINGS_FILE = "soapui-settings.xml";
    public static final String SOAPUI_SPLASH_GIF = "soapui-splash.gif";
    private static SoapUI instance;
    private static SoapuiSettingsDocumentConfig settingsDocument;
    private static List<Object> logCache;
    private static Settings settings;
    private static JFrame frame;
    private Navigator navigator;
    private SoapUIDesktop desktop;
    private static TestMonitor testMonitor;
    private Workspace workspace;
    private JDesktopPanelsList desktopPanelsList;
    private Log4JMonitor logMonitor;
    private JMenu desktopMenu;
    private JMenu fileMenu;
    private JMenuBar menuBar;
    public static boolean checkedGroovyLogMonitor;
    private JPanel overviewPanel;
    private JMenu toolsMenu;
    private boolean saveOnExit = true;
    private static MockEngine mockEngine;
    private static boolean loadedExtLibs;
    private static boolean isStandalone;
    private JSplitPane contentSplit;
    private InternalDesktopListener internalDesktopListener = new InternalDesktopListener();

    public SoapUI() {
        instance = this;
        testMonitor = new TestMonitor();
    }

    private void buildUI() {
        frame.addWindowListener(new MainFrameWindowListener());
        UISupport.setMainFrame(frame);
        this.navigator = new Navigator(this.workspace);
        this.navigator.addNavigatorListener(new InternalNavigatorListener());
        this.desktopPanelsList = new JDesktopPanelsList(this.desktop);
        JSplitPane splitPane = UISupport.createHorizontalSplit(this.buildMainPanel(), this.buildContentPanel());
        frame.setJMenuBar(this.buildMainMenu());
        frame.getContentPane().add((Component)splitPane, "Center");
        frame.setDefaultCloseOperation(0);
        frame.setSize(1000, 750);
        splitPane.setDividerLocation(250);
        this.navigator.selectModelItem(this.workspace);
        this.desktop.addDesktopListener(this.internalDesktopListener);
        ToolTipManager.sharedInstance().setInitialDelay(200);
    }

    private JMenuBar buildMainMenu() {
        this.menuBar = new JMenuBar();
        this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.menuBar.add(this.buildFileMenu());
        this.menuBar.add(this.buildToolsMenu());
        this.menuBar.add(this.buildDesktopMenu());
        this.menuBar.add(this.buildHelpMenu());
        return this.menuBar;
    }

    private JMenu buildDesktopMenu() {
        this.desktopMenu = new JMenu("Desktop");
        this.desktopMenu.setMnemonic(68);
        ActionSupport.addActions(this.desktop.getActions(), this.desktopMenu);
        return this.desktopMenu;
    }

    private JMenu buildHelpMenu() {
        this.desktopMenu = new JMenu("Help");
        this.desktopMenu.setMnemonic(72);
        this.desktopMenu.add(new ShowOnlineHelpAction("User Guide", "http://www.soapui.org/userguide/index.html"));
        this.desktopMenu.add(new ShowOnlineHelpAction("Getting Started", "http://www.soapui.org/gettingstarted/index.html"));
        this.desktopMenu.addSeparator();
        this.desktopMenu.add(new ShowSystemPropertiesAction());
        this.desktopMenu.addSeparator();
        this.desktopMenu.add(new OpenUrlAction("soapui.org", "http://www.soapui.org"));
        this.desktopMenu.add(new AboutAction());
        return this.desktopMenu;
    }

    private JMenu buildToolsMenu() {
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.add(new WSToolsWsdl2JavaAction(null));
        this.toolsMenu.add(new JBossWSConsumeAction(null));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new WSCompileAction(null));
        this.toolsMenu.add(new WSImportAction(null));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new Axis1XWSDL2JavaAction(null));
        this.toolsMenu.add(new Axis2WSDL2CodeAction(null));
        this.toolsMenu.add(new XFireAction(null));
        this.toolsMenu.add(new OracleWsaGenProxyAction(null));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new XmlBeans2Action(null));
        this.toolsMenu.add(new JaxbXjcAction(null));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new DotNetWsdlAction(null));
        this.toolsMenu.add(new GSoapAction(null));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new TcpMonAction(null));
        return this.toolsMenu;
    }

    private JMenu buildFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        ActionSupport.addActions(this.workspace.getActions(), this.fileMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(new SoapUIPreferencesAction());
        this.fileMenu.add(new SavePreferencesAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(new ExitAction());
        this.fileMenu.add(new ExitWithoutSavingAction());
        return this.fileMenu;
    }

    public JFrame getFrame() {
        return frame;
    }

    private JComponent buildMainPanel() {
        JSplitPane splitPane = UISupport.createVerticalSplit();
        splitPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        splitPane.setTopComponent(this.navigator);
        splitPane.setBottomComponent(this.buildOverviewPanel());
        splitPane.setDividerLocation(500);
        splitPane.setResizeWeight(0.6);
        return splitPane;
    }

    private Component buildOverviewPanel() {
        JTabbedPane detailTabs = new JTabbedPane(3);
        this.overviewPanel = new JPanel(new BorderLayout());
        detailTabs.addTab("Details", this.overviewPanel);
        detailTabs.addTab("Windows", new JScrollPane(this.desktopPanelsList));
        return UISupport.createTabPanel(detailTabs, true);
    }

    private void setOverviewPanel(Component panel) {
        if (this.overviewPanel.getComponentCount() == 0 && panel == null) {
            return;
        }
        this.overviewPanel.removeAll();
        if (panel != null) {
            this.overviewPanel.add(panel, "Center");
        }
        this.overviewPanel.revalidate();
        this.overviewPanel.repaint();
    }

    private Component buildContentPanel() {
        this.contentSplit = UISupport.createVerticalSplit();
        this.contentSplit.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.contentSplit.setTopComponent(this.desktop.getDesktopComponent());
        this.contentSplit.setBottomComponent(this.buildLogPanel(true, "soapUI log"));
        this.contentSplit.setDividerLocation(550);
        this.contentSplit.setResizeWeight(1.0);
        return this.contentSplit;
    }

    public Component buildLogPanel(boolean hasDefault, String defaultName) {
        this.logMonitor = new Log4JMonitor();
        this.logMonitor.addLogArea(defaultName, "com.eviware.soapui", hasDefault).setLevel(Level.DEBUG);
        this.logMonitor.addLogArea("http log", "httpclient.wire", false).setLevel(Level.DEBUG);
        this.logMonitor.addLogArea("jetty log", "jetty", false).setLevel(Level.INFO);
        for (Object message : logCache) {
            this.logMonitor.logEvent(message);
        }
        return UISupport.createTabPanel(this.logMonitor, true);
    }

    public static synchronized void log(final Object msg) {
        if (instance == null || SoapUI.instance.logMonitor == null) {
            logCache.add(msg);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            SoapUI.instance.logMonitor.logEvent(msg);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    instance.logMonitor.logEvent(msg);
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        String title = "soapUI 1.7.1";
        String splashImage = SOAPUI_SPLASH_GIF;
        SoapUI.startSoapUI(args, title, SoapUI.findSplash(splashImage));
    }

    public static URL findSplash(String filename) {
        File file = new File(filename);
        URL url = null;
        try {
            url = !file.exists() ? SoapUI.class.getResource("/" + filename) : file.toURL();
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            if (url == null) {
                url = new URL("http://www.soapui.org/images/" + filename);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return url;
    }

    public static void startSoapUI(String[] args, String title, URL splashImage) throws FactoryConfigurationError, SoapUIException {
        isStandalone = true;
        SoapUI.initSoapUILog();
        frame = new JFrame(title);
        new SoapUISplash(splashImage);
        SoapUI.initSoapUILookAndFeel();
        SoapUI.prepareSwingUI();
        SoapUI.loadExtLibs();
        DesktopRegistry.getInstance().addDesktop("Default", new StandaloneDesktopFactory());
        SoapUI soapUI = new SoapUI();
        Workspace workspace = null;
        workspace = args.length > 0 ? WorkspaceFactory.getInstance().openWorkspace(args) : WorkspaceFactory.getInstance().openWorkspace(new String[]{System.getProperty("user.home") + File.separatorChar + DEFAULT_WORKSPACE_FILE});
        soapUI.show(workspace);
    }

    public static boolean isStandalone() {
        return isStandalone;
    }

    public static void loadExtLibs() {
        if (loadedExtLibs) {
            return;
        }
        try {
            File dir = new File("ext");
            if (dir.exists() && dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    ClasspathHacker.addFile(file);
                }
            } else {
                log.info((Object)("Missing folder [" + dir.getAbsolutePath() + "] for external libraries"));
            }
            loadedExtLibs = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void prepareSwingUI() {
        UISupport.setToolHost(new SwingToolHost());
        XFormFactory.Factory.instance = new SwingFormFactory();
    }

    public static void initSoapUILookAndFeel() {
        try {
            if (SoapUI.getSettings().getBoolean(UISettings.NATIVE_LAF)) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                SoapUITheme theme = new SoapUITheme();
                PlasticXPLookAndFeel.setCurrentTheme((MetalTheme)((Object)theme));
                PlasticXPLookAndFeel.setTabStyle((String)"Metal");
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
                UIManager.put("TabbedPane.tabAreaInsets", new Insets(3, 2, 0, 0));
                UIManager.put("TabbedPane.unselectedBackground", new Color(220, 220, 220));
                UIManager.put("TabbedPane.selected", new Color(240, 240, 240));
                PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)theme);
            }
        }
        catch (Throwable e) {
            System.err.println("Error initializing PlasticXPLookAndFeel; " + e.getMessage());
        }
    }

    public static JMenuBar getMenuBar() {
        return instance == null ? null : SoapUI.instance.menuBar;
    }

    public static void initSoapUILog() throws FactoryConfigurationError {
        File log4jconfig = new File("soapui-log4j.xml");
        if (log4jconfig.exists()) {
            System.out.println("Configuring log4j from [" + log4jconfig + "]");
            DOMConfigurator.configureAndWatch((String)log4jconfig.getAbsolutePath(), (long)5000L);
        } else {
            URL log4jUrl = SoapUI.class.getResource("/soapui-log4j.xml");
            System.out.println("Configuring log4j from [" + log4jUrl + "]");
            DOMConfigurator.configure((URL)log4jUrl);
        }
    }

    private void show(Workspace workspace) {
        this.workspace = workspace;
        this.desktop = new StandaloneDesktop(workspace);
        String desktopType = SoapUI.getSettings().getString(UISettings.DESKTOP_TYPE, "Default");
        this.desktop = DesktopRegistry.getInstance().createDesktop(desktopType, workspace);
        if (this.desktop == null) {
            this.desktop = new StandaloneDesktop(workspace);
        }
        SoapUI.getSettings().addSettingsListener(new SettingsListener(){

            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(UISettings.DESKTOP_TYPE)) {
                    SoapUI.this.changeDesktop(DesktopRegistry.getInstance().createDesktop(newValue, SoapUI.this.workspace));
                }
            }
        });
        this.buildUI();
        testMonitor.addTestMonitorListener(new LogDisablingTestMonitorListener());
        testMonitor.init(workspace);
        frame.setVisible(true);
    }

    private void changeDesktop(SoapUIDesktop newDesktop) {
        this.desktopPanelsList.setDesktop(newDesktop);
        this.desktop.removeDesktopListener(this.internalDesktopListener);
        this.desktop.transferTo(newDesktop);
        this.desktop = newDesktop;
        this.contentSplit.setTopComponent(this.desktop.getDesktopComponent());
        this.desktop.addDesktopListener(this.internalDesktopListener);
        this.desktopMenu.removeAll();
        ActionSupport.addActions(this.desktop.getActions(), this.desktopMenu);
    }

    public static synchronized Logger ensureGroovyLog() {
        if (!checkedGroovyLogMonitor) {
            Log4JMonitor logMonitor = SoapUI.getLogMonitor();
            if (logMonitor != null && !logMonitor.hasLogArea("groovy.log")) {
                logMonitor.addLogArea("groovy log", "groovy.log", false);
            }
            checkedGroovyLogMonitor = true;
        }
        return Logger.getLogger((String)"groovy.log");
    }

    public static TestMonitor getTestMonitor() {
        return testMonitor;
    }

    public static void setTestMonitor(TestMonitor monitor) {
        testMonitor = monitor;
    }

    public static Log4JMonitor getLogMonitor() {
        return instance == null ? null : SoapUI.instance.logMonitor;
    }

    public static void setLogMonitor(Log4JMonitor monitor) {
        if (instance != null) {
            SoapUI.instance.logMonitor = monitor;
        }
    }

    public static Settings getSettings() {
        if (settings == null) {
            if (settingsDocument == null) {
                SoapUI.initSettings(DEFAULT_SETTINGS_FILE);
            }
            if (settingsDocument.getSoapuiSettings() == null) {
                settingsDocument.addNewSoapuiSettings();
                settings = new XmlBeansSettingsImpl(null, null, settingsDocument.getSoapuiSettings());
                settings.setBoolean(WsdlSettings.CACHE_WSDLS, true);
                settings.setBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES, true);
                settings.setBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, true);
                settings.setBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, true);
            } else {
                settings = new XmlBeansSettingsImpl(null, null, settingsDocument.getSoapuiSettings());
            }
            if (!settings.isSet(WsdlSettings.EXCLUDED_TYPES)) {
                StringList list = new StringList();
                list.add("schema@http://www.w3.org/2001/XMLSchema");
                settings.setString(WsdlSettings.EXCLUDED_TYPES, list.toXml());
            }
            if (!settings.isSet(WsdlSettings.NAME_WITH_BINDING)) {
                settings.setBoolean(WsdlSettings.NAME_WITH_BINDING, true);
            }
        }
        return settings;
    }

    public static void saveSettings() throws IOException {
        settingsDocument.save(new File(DEFAULT_SETTINGS_FILE));
        log.info((Object)"Saved global preferences to [soapui-settings.xml]");
    }

    public static void initSettings(String fileName) {
        try {
            File settingsFile = new File(fileName);
            settingsDocument = SoapuiSettingsDocumentConfig.Factory.parse((File)settingsFile);
            log.info((Object)("initialized soapui-settings from [" + fileName + "]"));
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load settings [" + e.getMessage() + "], creating new "));
            settingsDocument = SoapuiSettingsDocumentConfig.Factory.newInstance();
        }
    }

    public static void selectModelItem(ModelItem modelItem) {
        if (instance != null && SoapUI.instance.navigator != null) {
            SoapUI.instance.navigator.selectModelItem(modelItem);
        }
    }

    public static SoapUIDesktop getDesktop() {
        return instance != null ? SoapUI.instance.desktop : null;
    }

    public static void setDesktop(SoapUIDesktop desktop) {
        if (instance != null) {
            SoapUI.instance.desktop = desktop;
        }
    }

    public static Navigator getNavigator() {
        return instance != null ? SoapUI.instance.navigator : null;
    }

    public static void setNavigator(Navigator navigator) {
        if (instance != null) {
            SoapUI.instance.navigator = navigator;
        }
    }

    public static MockEngine getMockEngine() {
        if (mockEngine == null) {
            mockEngine = new MockEngine();
        }
        return mockEngine;
    }

    public static String getSchemaDirectory() {
        return SoapUI.getSettings().getString(WsdlSettings.SCHEMA_DIRECTORY, null);
    }

    public static Collection<? extends QName> getExcludedTypes() {
        ArrayList<QName> result = new ArrayList<QName>();
        String excluded = SoapUI.getSettings().getString(WsdlSettings.EXCLUDED_TYPES, null);
        if (excluded != null && excluded.trim().length() > 0) {
            try {
                StringList names = StringList.fromXml(excluded);
                for (String name : names) {
                    int ix = name.indexOf(64);
                    result.add(new QName(name.substring(ix + 1), name.substring(0, ix)));
                }
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    static {
        logCache = new ArrayList<Object>();
    }

    static class SoapUISplash
    extends JWindow {
        public SoapUISplash(URL splashImage) {
            super(frame);
            JLabel l = new JLabel(new ImageIcon(splashImage));
            this.getContentPane().add((Component)l, "Center");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = l.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (frame.isVisible()) {
                        SoapUISplash.this.setVisible(false);
                        SoapUISplash.this.dispose();
                    }
                }
            });
            int pause = 1000;
            final Runnable closerRunner = new Runnable(){

                public void run() {
                    SoapUISplash.this.setVisible(false);
                    SoapUISplash.this.dispose();
                }
            };
            Runnable waitRunner = new Runnable(){

                public void run() {
                    try {
                        do {
                            Thread.sleep(1000L);
                        } while (!frame.isVisible());
                        SwingUtilities.invokeAndWait(closerRunner);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.setVisible(true);
            Thread splashThread = new Thread(waitRunner, "SplashThread");
            splashThread.start();
        }
    }

    private class SavePreferencesAction
    extends AbstractAction {
        public SavePreferencesAction() {
            super("Save Preferences");
            this.putValue("ShortDescription", "Saves all global preferences");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SoapUI.saveSettings();
            }
            catch (IOException e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class ExitWithoutSavingAction
    extends AbstractAction {
        public ExitWithoutSavingAction() {
            super("Exit without saving");
            this.putValue("ShortDescription", "Saves all projects and exits SoapUI");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl alt Q"));
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = false;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("About soapUI");
            this.putValue("ShortDescription", "Shows information on soapUI");
        }

        public void actionPerformed(ActionEvent e) {
            URI splashURI = null;
            try {
                splashURI = SoapUI.findSplash(SoapUI.SOAPUI_SPLASH_GIF).toURI();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            Properties props = new Properties();
            try {
                props.load(SoapUI.class.getResourceAsStream("/buildinfo.txt"));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            UISupport.showExtendedInfo("About soapUI", null, "<html><body><p align=center><img src=\"" + splashURI + "\"><br>soapUI " + SoapUI.SOAPUI_VERSION + ", copyright (C) 2004-2007 eviware.com<br>" + "<a href=\"http://www.soapui.org\">http://www.soapui.org</a> | " + "<a href=\"http://www.eviware.com\">http://www.eviware.com</a><br>" + "Build " + props.getProperty("build.number") + ", Build Date " + props.getProperty("build.date") + "</p></body></html>", new Dimension(470, 350));
        }
    }

    private class ShowSystemPropertiesAction
    extends AbstractAction {
        public ShowSystemPropertiesAction() {
            super("System Properties");
            this.putValue("ShortDescription", "Shows the current systems properties");
        }

        public void actionPerformed(ActionEvent e) {
            StringBuffer buffer = new StringBuffer();
            Properties properties = System.getProperties();
            ArrayList<String> keys = new ArrayList<String>();
            for (Object key : properties.keySet()) {
                keys.add(key.toString());
            }
            Collections.sort(keys);
            String lastKey = null;
            for (String key : keys) {
                int ix;
                if (lastKey != null && !key.startsWith(lastKey)) {
                    buffer.append("\r\n");
                }
                lastKey = (ix = key.indexOf(46)) == -1 ? key : key.substring(0, ix);
                buffer.append(key).append('=').append(properties.get(key)).append("\r\n");
            }
            UISupport.showExtendedInfo("System Properties", "Current system properties", "<html><body><pre><font size=-1>" + buffer.toString() + "</font></pre></body></html>", new Dimension(600, 400));
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
            this.putValue("ShortDescription", "Saves all projects and exits SoapUI");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Q"));
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = true;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    public class InternalNavigatorListener
    implements NavigatorListener {
        public void nodeSelected(SoapUITreeNode treeNode) {
            if (treeNode == null) {
                SoapUI.this.setOverviewPanel(null);
            } else {
                PanelBuilder<ModelItem> panelBuilder = PanelBuilderRegistry.getPanelBuilder(treeNode.getModelItem());
                if (panelBuilder != null && panelBuilder.hasOverviewPanel()) {
                    SoapUI.this.setOverviewPanel(panelBuilder.buildOverviewPanel(treeNode.getModelItem()));
                } else {
                    SoapUI.this.setOverviewPanel(null);
                }
            }
        }
    }

    public static class SoapUITheme
    extends SkyBluer {
        public static final Color BACKGROUND_COLOR = new Color(240, 240, 240);

        public ColorUIResource getControl() {
            return new ColorUIResource(BACKGROUND_COLOR);
        }

        public ColorUIResource getMenuBackground() {
            return this.getControl();
        }

        public ColorUIResource getMenuItemBackground() {
            return new ColorUIResource(new Color(248, 248, 248));
        }
    }

    private final class MainFrameWindowListener
    extends WindowAdapter {
        private MainFrameWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (SoapUI.this.saveOnExit) {
                if (!UISupport.confirm("Exit SoapUI?", "Question")) {
                    return;
                }
                SoapUI.this.workspace.onClose();
                try {
                    SoapUI.saveSettings();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (!UISupport.confirm("Exit SoapUI without saving?", "Question")) {
                SoapUI.this.saveOnExit = true;
                return;
            }
            frame.dispose();
        }

        public void windowClosed(WindowEvent e) {
            System.out.println("exiting..");
            System.exit(0);
        }
    }

    private final class InternalDesktopListener
    extends DesktopListenerAdapter {
        private InternalDesktopListener() {
        }

        public void desktopPanelSelected(DesktopPanel desktopPanel) {
            ModelItem modelItem = desktopPanel.getModelItem();
            if (modelItem != null) {
                SoapUI.this.navigator.selectModelItem(modelItem);
            }
        }
    }
}

