/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AbstractUserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserManager
extends AbstractUserManager
implements Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)LdapUserManager.class);
    private static final String CN = "cn";
    private static final String CLASS_NAME = "javaClassName";
    private static final String OBJ_CLASS = "objectClass";
    private static final String[] CN_ATTRS = new String[]{"cn"};
    private String adminName;
    private DirContext adminContext;
    private String userBaseDn;
    private Attribute objClassAttr;

    public void configure(Configuration config) throws FtpException {
        try {
            this.adminName = config.getString("admin", "admin");
            String url = config.getString("ldap-url");
            String admin = config.getString("ldap-admin-dn");
            String password = config.getString("ldap-admin-password");
            String auth = config.getString("ldap-authentication", "simple");
            this.userBaseDn = config.getString("ldap-user-base-dn");
            Properties adminEnv = new Properties();
            adminEnv.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            adminEnv.setProperty("java.naming.provider.url", url);
            adminEnv.setProperty("java.naming.security.authentication", auth);
            adminEnv.setProperty("java.naming.security.principal", admin);
            adminEnv.setProperty("java.naming.security.credentials", password);
            this.adminContext = new InitialDirContext(adminEnv);
            this.objClassAttr = new BasicAttribute(OBJ_CLASS, false);
            this.objClassAttr.add("javaObject");
            this.objClassAttr.add("top");
            this.LOG.info("LDAP user manager opened.");
        }
        catch (FtpException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.LOG.error("LdapUserManager.configure()", (Throwable)ex);
            throw new FtpException("LdapUserManager.configure()", (Throwable)ex);
        }
    }

    public String getAdminName() {
        return this.adminName;
    }

    public boolean isAdmin(String login) throws FtpException {
        return this.adminName.equals(login);
    }

    public synchronized String[] getAllUserNames() throws FtpException {
        try {
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(this.objClassAttr);
            matchAttrs.put(new BasicAttribute(CLASS_NAME, BaseUser.class.getName()));
            NamingEnumeration<SearchResult> answers = this.adminContext.search(this.userBaseDn, (Attributes)matchAttrs, CN_ATTRS);
            this.LOG.info("Getting all users under " + this.userBaseDn);
            ArrayList<String> allUsers = new ArrayList<String>();
            while (answers.hasMore()) {
                SearchResult sr = answers.next();
                String cn = sr.getAttributes().get(CN).get().toString();
                allUsers.add(cn);
            }
            Collections.sort(allUsers);
            return allUsers.toArray(new String[0]);
        }
        catch (NamingException ex) {
            this.LOG.error("LdapUserManager.getAllUserNames()", (Throwable)ex);
            throw new FtpException("LdapUserManager.getAllUserNames()", (Throwable)ex);
        }
    }

    public synchronized User getUserByName(String name) throws FtpException {
        User user = null;
        try {
            String dn = this.getDN(name);
            this.LOG.info("Getting user object for " + dn);
            user = (User)this.adminContext.lookup(dn);
        }
        catch (NamingException ex) {
            this.LOG.debug("Failed to retrive user: " + name, (Throwable)ex);
            user = null;
        }
        return user;
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            User user;
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String login = upauth.getUsername();
            String password = upauth.getPassword();
            if (login == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            try {
                user = this.getUserByName(login);
            }
            catch (FtpException e) {
                throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
            }
            if (user != null && password.equals(user.getPassword())) {
                return user;
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        if (authentication instanceof AnonymousAuthentication) {
            try {
                if (this.doesExist("anonymous")) {
                    return this.getUserByName("anonymous");
                }
                throw new AuthenticationFailedException("Authentication failed");
            }
            catch (FtpException e) {
                throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Authentication not supported by this user manager");
    }

    public synchronized void save(User user) throws FtpException {
        try {
            String name = user.getName();
            String dn = this.getDN(name);
            BaseUser newUser = new BaseUser(user);
            User existUser = this.getUserByName(name);
            if (existUser != null && newUser.getPassword() == null) {
                newUser.setPassword(existUser.getPassword());
            }
            BasicAttributes attrs = new BasicAttributes(true);
            attrs.put(new BasicAttribute(CN, name));
            attrs.put(new BasicAttribute(CLASS_NAME, BaseUser.class.getName()));
            this.LOG.info("Rebinding user " + dn);
            this.adminContext.rebind(dn, (Object)newUser, (Attributes)attrs);
        }
        catch (NamingException ex) {
            this.LOG.error("LdapUserManager.save()", (Throwable)ex);
            throw new FtpException("LdapUserManager.save()", (Throwable)ex);
        }
    }

    public synchronized boolean doesExist(String name) throws FtpException {
        return this.getUserByName(name) != null;
    }

    public synchronized void delete(String userName) throws FtpException {
        try {
            String dn = this.getDN(userName);
            this.LOG.info("Unbinding " + dn);
            this.adminContext.unbind(dn);
        }
        catch (NamingException ex) {
            this.LOG.error("LdapUserManager.delete()", (Throwable)ex);
            throw new FtpException("LdapUserManager.delete()", (Throwable)ex);
        }
    }

    public synchronized void dispose() {
        if (this.adminContext != null) {
            try {
                this.adminContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.adminContext = null;
        }
    }

    private String getDN(String userName) throws NamingException {
        StringBuffer valBuf = new StringBuffer(userName);
        for (int i = 0; i < valBuf.length(); ++i) {
            char ch = valBuf.charAt(i);
            if (ch != '\\' && ch != ',' && ch != '+' && ch != '\"' && ch != '<' && ch != '>' && ch != ';') continue;
            valBuf.insert(i, '\\');
            ++i;
        }
        return "cn=" + valBuf.toString() + ',' + this.userBaseDn;
    }
}

