/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.io;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.AbstractListener;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.listener.io.IOConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOListener
extends AbstractListener
implements Runnable {
    private final Logger LOG = LoggerFactory.getLogger((Class)IOListener.class);
    private FtpServerContext serverContext;
    private ServerSocket serverSocket;
    private Thread listenerThread;
    private boolean suspended = false;

    public void start(FtpServerContext serverContext) throws Exception {
        this.serverContext = serverContext;
        this.serverSocket = this.createServerSocket();
        this.listenerThread = new Thread(this);
        this.listenerThread.start();
    }

    private ServerSocket createServerSocket() throws Exception {
        ServerSocket ssocket = null;
        ssocket = this.isImplicitSsl() ? this.getSsl().createServerSocket(null, this.getServerAddress(), this.getPort()) : (this.getServerAddress() == null ? new ServerSocket(this.getPort(), 100) : new ServerSocket(this.getPort(), 100, this.getServerAddress()));
        return ssocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.serverSocket == null) {
            throw new IllegalStateException("start() must be called before run()");
        }
        this.LOG.info("Listener started on port " + this.serverSocket.getLocalPort());
        if (this.serverContext == null) {
            return;
        }
        ConnectionManager conManager = this.serverContext.getConnectionManager();
        try {
            while (true) {
                if (this.serverSocket == null) {
                    return;
                }
                Socket soc = this.serverSocket.accept();
                if (this.suspended) {
                    try {
                        soc.close();
                    }
                    catch (Exception ex) {}
                    continue;
                }
                IOConnection connection = new IOConnection(this.serverContext, soc, this);
                conManager.newConnection(connection);
            }
        }
        catch (SocketException ex) {
            return;
        }
        catch (Exception ex) {
            this.LOG.debug("Listener ending", (Throwable)ex);
            return;
        }
    }

    public synchronized void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        this.listenerThread.interrupt();
        if (this.listenerThread != null && this.listenerThread.isAlive()) {
            try {
                this.listenerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.listenerThread = null;
        }
    }

    public boolean isStopped() {
        return this.listenerThread == null;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() {
        this.suspended = false;
    }

    public void suspend() {
        this.suspended = true;
    }
}

