/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REST
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)REST.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException {
        String argument = request.getArgument();
        if (argument == null) {
            out.write(FtpReplyUtil.translate(session, 501, "REST", null));
            return;
        }
        session.resetState();
        long skipLen = 0L;
        try {
            skipLen = Long.parseLong(argument);
            if (skipLen < 0L) {
                skipLen = 0L;
                out.write(FtpReplyUtil.translate(session, 501, "REST.negetive", null));
            } else {
                out.write(FtpReplyUtil.translate(session, 350, "REST", null));
            }
        }
        catch (NumberFormatException ex) {
            this.LOG.debug("Invalid restart position: " + argument, (Throwable)ex);
            out.write(FtpReplyUtil.translate(session, 501, "REST.invalid", null));
        }
        session.setFileOffset(skipLen);
    }
}

