/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)MD5.class);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException {
        String argument;
        session.resetState();
        boolean isMMD5 = false;
        if ("MMD5".equals(request.getCommand())) {
            isMMD5 = true;
        }
        if ((argument = request.getArgument()) == null || argument.trim().length() == 0) {
            out.write(FtpReplyUtil.translate(session, 504, "MD5.invalid", null));
            return;
        }
        String[] fileNames = null;
        fileNames = isMMD5 ? argument.split(",") : new String[]{argument};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i].trim();
            FileObject file = null;
            try {
                file = session.getFileSystemView().getFileObject(fileName);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting the file object: " + fileName, (Throwable)ex);
            }
            if (file == null) {
                out.write(FtpReplyUtil.translate(session, 504, "MD5.invalid", fileName));
                return;
            }
            if (!file.isFile()) {
                out.write(FtpReplyUtil.translate(session, 504, "MD5.invalid", fileName));
                return;
            }
            InputStream is = null;
            try {
                is = file.createInputStream(0L);
                String md5Hash = this.md5(is);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(fileName);
                sb.append(' ');
                sb.append(md5Hash);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                this.LOG.debug("MD5 algorithm not available", (Throwable)e);
                out.write(FtpReplyUtil.translate(session, 502, "MD5.notimplemened", null));
                continue;
            }
            finally {
                IoUtils.close(is);
            }
        }
        if (isMMD5) {
            out.write(FtpReplyUtil.translate(session, 252, "MMD5", sb.toString()));
        } else {
            out.write(FtpReplyUtil.translate(session, 251, "MD5", sb.toString()));
        }
    }

    private String md5(InputStream is) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        DigestInputStream dis = new DigestInputStream(is, digest);
        byte[] buffer = new byte[1024];
        int read = dis.read(buffer);
        while (read > -1) {
            read = dis.read(buffer);
        }
        return new String(MD5.encodeHex(dis.getMessageDigest().digest()));
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

