/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.ConnectionObserver;

public class FtpRequestImpl
implements FtpRequest {
    private String line;
    private String command;
    private String argument;
    private ConnectionObserver observer;

    public FtpRequestImpl(String requestLine) {
        this.parse(requestLine);
    }

    private void parse(String lineToParse) {
        this.spyRequest(lineToParse);
        this.line = lineToParse.trim();
        this.command = null;
        this.argument = null;
        int spInd = this.line.indexOf(32);
        if (spInd != -1) {
            this.argument = this.line.substring(spInd + 1);
            if (this.argument.equals("")) {
                this.argument = null;
            }
            this.command = this.line.substring(0, spInd).toUpperCase();
        } else {
            this.command = this.line.toUpperCase();
        }
        if (this.command.length() > 0 && this.command.charAt(0) == 'X') {
            this.command = this.command.substring(1);
        }
    }

    private void spyRequest(String str) {
        ConnectionObserver observer = this.observer;
        if (observer != null) {
            observer.request(str + "\r\n");
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getRequestLine() {
        return this.line;
    }

    public boolean hasArgument() {
        return this.getArgument() != null;
    }

    public String toString() {
        return this.getRequestLine();
    }
}

