/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.server;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;
import org.jboss.tm.usertx.interfaces.UserTransactionSession;
import org.jboss.util.collection.WeakValueHashMap;

public class UserTransactionSessionImpl
implements UserTransactionSession {
    private static TransactionManager tm = null;
    private static Logger log = Logger.getLogger(UserTransactionSessionImpl.class);
    private static WeakValueHashMap activeTx = new WeakValueHashMap();
    private static UserTransactionSessionImpl instance = new UserTransactionSessionImpl();
    private static TransactionPropagationContextFactory tpcFactory = null;

    public static UserTransactionSession getInstance() {
        return instance;
    }

    protected static TransactionManager getTransactionManager() {
        if (tm == null) {
            try {
                InitialContext ctx = new InitialContext();
                tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            }
            catch (NamingException ex) {
                log.error((Object)"java:/TransactionManager lookup failed", (Throwable)ex);
            }
        }
        return tm;
    }

    protected static TransactionPropagationContextFactory getTPCFactory() {
        if (tpcFactory == null) {
            tpcFactory = TransactionPropagationContextUtil.getTPCFactory();
        }
        return tpcFactory;
    }

    public void destroy() throws RemoteException {
        this.unreferenced();
    }

    public Object begin(int timeout) throws RemoteException, NotSupportedException, SystemException {
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        tm.setTransactionTimeout(timeout);
        tm.begin();
        Object tpc = UserTransactionSessionImpl.getTPCFactory().getTransactionPropagationContext();
        Transaction tx = tm.suspend();
        activeTx.put(tpc, (Object)tx);
        return tpc;
    }

    public void commit(Object tpc) throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        tm.resume(tx);
        boolean finished = true;
        try {
            tm.commit();
        }
        catch (SecurityException ex) {
            finished = false;
            throw ex;
        }
        catch (IllegalStateException ex) {
            finished = false;
            throw ex;
        }
        finally {
            activeTx.remove(tpc);
        }
    }

    public void rollback(Object tpc) throws RemoteException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        TransactionManager tm = UserTransactionSessionImpl.getTransactionManager();
        tm.resume(tx);
        tm.rollback();
        activeTx.remove(tpc);
    }

    public void setRollbackOnly(Object tpc) throws RemoteException, IllegalStateException, SystemException {
        Transaction tx = (Transaction)activeTx.get(tpc);
        if (tx == null) {
            throw new IllegalStateException("No transaction.");
        }
        tx.setRollbackOnly();
    }

    public int getStatus(Object tpc) throws RemoteException, SystemException {
        Transaction tx = (Transaction)activeTx.get(tpc);
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void unreferenced() {
        log.debug((Object)"Lost connection to UserTransaction client.");
        if (!activeTx.isEmpty()) {
            log.error((Object)("Lost connection to UserTransaction clients: Rolling back " + activeTx.size() + " active transaction(s)."));
            Collection txs = activeTx.values();
            for (Transaction tx : txs) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"rollback failed", (Throwable)ex);
                }
            }
        }
    }
}

