/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

public class MethodAttributes {
    String pattern;
    boolean readOnly;
    boolean idempotent;
    int txTimeout;
    public static MethodAttributes kDefaultMethodAttributes = new MethodAttributes();

    public boolean patternMatches(String methodName) {
        int ct;
        int end = this.pattern.length();
        if (end > methodName.length()) {
            return false;
        }
        for (ct = 0; ct < end; ++ct) {
            char c = this.pattern.charAt(ct);
            if (c == '*') {
                return true;
            }
            if (c == methodName.charAt(ct)) continue;
            return false;
        }
        return ct == methodName.length();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public int getTransactionTimeout() {
        return this.txTimeout;
    }

    static {
        MethodAttributes.kDefaultMethodAttributes.pattern = "*";
        MethodAttributes.kDefaultMethodAttributes.readOnly = false;
        MethodAttributes.kDefaultMethodAttributes.idempotent = false;
        MethodAttributes.kDefaultMethodAttributes.txTimeout = 0;
    }
}

