/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.StringTokenizer;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.w3c.dom.Element;

public class EjbPortComponentMetaData {
    private SessionMetaData sessionMetaData;
    private String portComponentName;
    private String portComponentURI;
    private String authMethod;
    private String transportGuarantee;
    private Boolean secureWSDLAccess;

    public EjbPortComponentMetaData(SessionMetaData sessionMetaData) {
        this.sessionMetaData = sessionMetaData;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public String getPortComponentURI() {
        return this.portComponentURI;
    }

    public String getURLPattern() {
        String pattern = "/*";
        if (this.portComponentURI != null) {
            return this.portComponentURI;
        }
        return pattern;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public Boolean getSecureWSDLAccess() {
        return this.secureWSDLAccess;
    }

    public void importStandardXml(Element element) throws DeploymentException {
    }

    public void importJBossXml(Element element) throws DeploymentException {
        ApplicationMetaData appMetaData = this.sessionMetaData.getApplicationMetaData();
        String contextRoot = appMetaData.getWebServiceContextRoot();
        this.portComponentName = MetaData.getUniqueChildContent(element, "port-component-name");
        this.portComponentURI = MetaData.getOptionalChildContent(element, "port-component-uri");
        if (this.portComponentURI != null) {
            if (this.portComponentURI.charAt(0) != '/') {
                this.portComponentURI = "/" + this.portComponentURI;
            }
            if (contextRoot == null) {
                StringTokenizer st = new StringTokenizer(this.portComponentURI, "/");
                if (st.countTokens() < 2) {
                    throw new DeploymentException("Expected at least two tokens <port-component-uri>");
                }
                contextRoot = "/" + st.nextToken();
                String prevContextRoot = contextRoot;
                if (prevContextRoot != null && !prevContextRoot.equals(contextRoot)) {
                    throw new DeploymentException("Invalid <port-component-uri>, expected to start with: " + prevContextRoot);
                }
                appMetaData.setWebServiceContextRoot(contextRoot);
                this.portComponentURI = this.portComponentURI.substring(this.portComponentURI.indexOf(47, 1));
            } else if (this.portComponentURI.startsWith(contextRoot)) {
                this.portComponentURI = this.portComponentURI.substring(contextRoot.length());
            }
        } else {
            this.portComponentURI = "/" + this.sessionMetaData.getEjbName();
        }
        this.authMethod = MetaData.getOptionalChildContent(element, "auth-method");
        this.transportGuarantee = MetaData.getOptionalChildContent(element, "transport-guarantee");
        if (MetaData.getOptionalChildContent(element, "secure-wsdl-access") != null) {
            this.secureWSDLAccess = Boolean.valueOf(MetaData.getOptionalChildContent(element, "secure-wsdl-access"));
        }
    }
}

