/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCActivateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateBeanClassInstanceCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDeleteRelationsCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCDestroyCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindEntitiesCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCFindEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInitCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInitEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertRelationsCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIsModifiedCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadRelationCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCPassivateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCPostCreateEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCRemoveEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStartCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStopCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreEntityCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.ReadAheadCache;
import org.jboss.ejb.plugins.cmp.jdbc.RelationData;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCXmlFileLoader;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.tm.TransactionLocal;

public final class JDBCStoreManager
implements JDBCEntityPersistenceStore {
    private static final Object TX_DATA_KEY = "TX_DATA_KEY";
    private static final String CATALOG = "CATALOG";
    private static final String CREATED_MANAGERS = "CREATED_JDBCStoreManagers";
    private static final String CMP_JDBC = "CMP-JDBC";
    private EjbModule ejbModule;
    private EntityContainer container;
    private Logger log;
    private JDBCEntityMetaData metaData;
    private JDBCEntityBridge entityBridge;
    private JDBCTypeFactory typeFactory;
    private JDBCQueryManager queryManager;
    private JDBCCommandFactory commandFactory;
    private ReadAheadCache readAheadCache;
    private JDBCInitCommand initCommand;
    private JDBCStartCommand startCommand;
    private JDBCStopCommand stopCommand;
    private JDBCDestroyCommand destroyCommand;
    private JDBCCreateBeanClassInstanceCommand createBeanClassInstanceCommand;
    private JDBCInitEntityCommand initEntityCommand;
    private JDBCFindEntityCommand findEntityCommand;
    private JDBCFindEntitiesCommand findEntitiesCommand;
    private JDBCCreateCommand createEntityCommand;
    private JDBCPostCreateEntityCommand postCreateEntityCommand;
    private JDBCRemoveEntityCommand removeEntityCommand;
    private JDBCLoadEntityCommand loadEntityCommand;
    private JDBCIsModifiedCommand isModifiedCommand;
    private JDBCStoreEntityCommand storeEntityCommand;
    private JDBCActivateEntityCommand activateEntityCommand;
    private JDBCPassivateEntityCommand passivateEntityCommand;
    private JDBCLoadRelationCommand loadRelationCommand;
    private JDBCDeleteRelationsCommand deleteRelationsCommand;
    private JDBCInsertRelationsCommand insertRelationsCommand;
    private TransactionManager tm;
    private TransactionLocal txDataMap;
    private TransactionLocal cascadeDeleteSet = new TransactionLocal(){

        protected Object initialValue() {
            return new CascadeDeleteRegistry();
        }
    };

    public EntityContainer getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
        if (container != null) {
            this.ejbModule = container.getEjbModule();
            this.log = Logger.getLogger((String)(this.getClass().getName() + "." + container.getBeanMetaData().getEjbName()));
        } else {
            this.ejbModule = null;
        }
    }

    public JDBCAbstractEntityBridge getEntityBridge() {
        return this.entityBridge;
    }

    public JDBCTypeFactory getJDBCTypeFactory() {
        return this.typeFactory;
    }

    public JDBCEntityMetaData getMetaData() {
        return this.metaData;
    }

    public JDBCQueryManager getQueryManager() {
        return this.queryManager;
    }

    public JDBCCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public ReadAheadCache getReadAheadCache() {
        return this.readAheadCache;
    }

    public Map getApplicationDataMap() {
        return this.ejbModule.getModuleDataMap();
    }

    public Object getApplicationData(Object key) {
        return this.ejbModule.getModuleData(key);
    }

    public void putApplicationData(Object key, Object value) {
        this.ejbModule.putModuleData(key, value);
    }

    private Map getApplicationTxDataMap() {
        try {
            int status;
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                return null;
            }
            HashMap txMap = (HashMap)this.txDataMap.get(tx);
            if (txMap == null && ((status = tx.getStatus()) == 0 || status == 7)) {
                txMap = new HashMap();
                this.txDataMap.set(tx, txMap);
            }
            return txMap;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error getting application tx data map.", e);
        }
    }

    public void scheduleCascadeDelete(List pks) {
        CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
        registry.scheduleAll(pks);
    }

    public boolean unscheduledCascadeDelete(Object pk) {
        CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
        return registry.unschedule(pk);
    }

    public Object getApplicationTxData(Object key) {
        Map map = this.getApplicationTxDataMap();
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public void putApplicationTxData(Object key, Object value) {
        Map map = this.getApplicationTxDataMap();
        if (map != null) {
            map.put(key, value);
        }
    }

    private Map getEntityTxDataMap() {
        HashMap entityTxDataMap = (HashMap)this.getApplicationTxData(this);
        if (entityTxDataMap == null) {
            entityTxDataMap = new HashMap();
            this.putApplicationTxData(this, entityTxDataMap);
        }
        return entityTxDataMap;
    }

    public Object getEntityTxData(Object key) {
        return this.getEntityTxDataMap().get(key);
    }

    public void putEntityTxData(Object key, Object value) {
        this.getEntityTxDataMap().put(key, value);
    }

    public void removeEntityTxData(Object key) {
        this.getEntityTxDataMap().remove(key);
    }

    public Catalog getCatalog() {
        return (Catalog)this.getApplicationData(CATALOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initApplicationDataMap() {
        Map moduleData;
        Map map = moduleData = this.ejbModule.getModuleDataMap();
        synchronized (map) {
            this.txDataMap = (TransactionLocal)moduleData.get(TX_DATA_KEY);
            if (this.txDataMap == null) {
                this.txDataMap = new TransactionLocal();
                moduleData.put(TX_DATA_KEY, this.txDataMap);
            }
        }
    }

    public void create() throws Exception {
        HashMap<String, JDBCStoreManager> managersMap = (HashMap<String, JDBCStoreManager>)this.getApplicationData(CREATED_MANAGERS);
        if (managersMap == null) {
            managersMap = new HashMap<String, JDBCStoreManager>();
            this.putApplicationData(CREATED_MANAGERS, managersMap);
        }
        managersMap.put(this.container.getBeanMetaData().getEjbName(), this);
    }

    public void start() throws Exception {
        this.initStoreManager();
        Catalog catalog = this.getCatalog();
        HashMap managersMap = (HashMap)this.getApplicationData(CREATED_MANAGERS);
        if (catalog.getEntityCount() == managersMap.size() && ((Object)catalog.getEJBNames()).equals(managersMap.keySet())) {
            JDBCStoreManager manager;
            int i;
            ArrayList managers = new ArrayList(managersMap.values());
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager)managers.get(i);
                manager.resolveRelationships();
            }
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager)managers.get(i);
                manager.startStoreManager();
            }
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager)managers.get(i);
                manager.startCommand.addForeignKeyConstraints();
            }
        }
    }

    private void initStoreManager() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing CMP plugin for " + this.container.getBeanMetaData().getEjbName()));
        }
        this.tm = this.container.getTransactionManager();
        this.initApplicationDataMap();
        this.metaData = this.loadJDBCEntityMetaData();
        this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
        this.entityBridge = new JDBCEntityBridge(this.metaData, this);
        this.entityBridge.init();
        Catalog catalog = this.getCatalog();
        if (catalog == null) {
            catalog = new Catalog();
            this.putApplicationData(CATALOG, catalog);
        }
        catalog.addEntity(this.entityBridge);
        this.readAheadCache = new ReadAheadCache(this);
        this.readAheadCache.create();
        this.commandFactory = new JDBCCommandFactory(this);
        this.initCommand = this.commandFactory.createInitCommand();
        this.initCommand.execute();
    }

    private void resolveRelationships() throws Exception {
        this.entityBridge.resolveRelationships();
    }

    private void startStoreManager() throws Exception {
        this.entityBridge.start();
        this.startCommand = this.commandFactory.createStartCommand();
        this.stopCommand = this.commandFactory.createStopCommand();
        this.destroyCommand = this.commandFactory.createDestroyCommand();
        this.initEntityCommand = this.commandFactory.createInitEntityCommand();
        this.createBeanClassInstanceCommand = this.commandFactory.createCreateBeanClassInstanceCommand();
        this.findEntityCommand = this.commandFactory.createFindEntityCommand();
        this.findEntitiesCommand = this.commandFactory.createFindEntitiesCommand();
        this.createEntityCommand = this.commandFactory.createCreateEntityCommand();
        this.postCreateEntityCommand = this.commandFactory.createPostCreateEntityCommand();
        this.removeEntityCommand = this.commandFactory.createRemoveEntityCommand();
        this.loadEntityCommand = this.commandFactory.createLoadEntityCommand();
        this.isModifiedCommand = this.commandFactory.createIsModifiedCommand();
        this.storeEntityCommand = this.commandFactory.createStoreEntityCommand();
        this.activateEntityCommand = this.commandFactory.createActivateEntityCommand();
        this.passivateEntityCommand = this.commandFactory.createPassivateEntityCommand();
        this.loadRelationCommand = this.commandFactory.createLoadRelationCommand();
        this.deleteRelationsCommand = this.commandFactory.createDeleteRelationsCommand();
        this.insertRelationsCommand = this.commandFactory.createInsertRelationsCommand();
        this.queryManager = new JDBCQueryManager(this);
        this.startCommand.execute();
        this.queryManager.start();
        this.readAheadCache.start();
    }

    public void stop() {
        if (this.stopCommand != null) {
            HashMap managersMap = (HashMap)this.getApplicationData(CREATED_MANAGERS);
            while (!managersMap.isEmpty()) {
                int stoppedInIteration = 0;
                Iterator i = managersMap.values().iterator();
                while (i.hasNext()) {
                    JDBCStoreManager manager = (JDBCStoreManager)i.next();
                    if (manager.stopCommand != null && !manager.stopCommand.execute()) continue;
                    i.remove();
                    ++stoppedInIteration;
                }
                if (stoppedInIteration != 0) continue;
                break;
            }
        }
        this.readAheadCache.stop();
    }

    public void destroy() {
        if (this.destroyCommand != null) {
            this.destroyCommand.execute();
        }
        if (this.readAheadCache != null) {
            this.readAheadCache.destroy();
        }
        this.readAheadCache = null;
        if (this.queryManager != null) {
            this.queryManager.clear();
        }
        this.queryManager = null;
        if (this.createBeanClassInstanceCommand != null) {
            this.createBeanClassInstanceCommand.destroy();
        }
    }

    public Object createBeanClassInstance() throws Exception {
        if (this.createBeanClassInstanceCommand == null) {
            throw new IllegalStateException("createBeanClassInstanceCommand == null");
        }
        return this.createBeanClassInstanceCommand.execute();
    }

    public void initEntity(EntityEnterpriseContext ctx) {
        this.initEntityCommand.execute(ctx);
    }

    public Object createEntity(Method createMethod, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        Object pk = this.createEntityCommand.execute(createMethod, args, ctx);
        if (pk == null) {
            throw new CreateException("Primary key for created instance is null.");
        }
        return pk;
    }

    public Object postCreateEntity(Method createMethod, Object[] args, EntityEnterpriseContext ctx) {
        return this.postCreateEntityCommand.execute(createMethod, args, ctx);
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        return this.findEntityCommand.execute(finderMethod, args, ctx, factory);
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        return this.findEntitiesCommand.execute(finderMethod, args, ctx, factory);
    }

    public void activateEntity(EntityEnterpriseContext ctx) {
        this.activateEntityCommand.execute(ctx);
    }

    public void loadEntity(EntityEnterpriseContext ctx) {
        this.loadEntity(ctx, true);
    }

    public boolean loadEntity(EntityEnterpriseContext ctx, boolean failIfNotFound) {
        if (!ctx.isValid()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("RESET PERSISTENCE CONTEXT: id=" + ctx.getId()));
            }
            this.entityBridge.resetPersistenceContext(ctx);
        }
        JDBCEntityBridge.setCreated(ctx);
        return this.loadEntityCommand.execute(ctx, failIfNotFound);
    }

    public void loadField(JDBCCMPFieldBridge field, EntityEnterpriseContext ctx) {
        this.loadEntityCommand.execute(field, ctx);
    }

    public boolean isStoreRequired(EntityEnterpriseContext ctx) {
        return this.isModifiedCommand.execute(ctx);
    }

    public boolean isModified(EntityEnterpriseContext ctx) {
        return this.entityBridge.isModified(ctx);
    }

    public void storeEntity(EntityEnterpriseContext ctx) {
        this.storeEntityCommand.execute(ctx);
        this.synchronizeRelationData();
    }

    private void synchronizeRelationData() {
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.entityBridge.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge.RelationDataManager relationManager = cmrFields[i].getRelationDataManager();
            if (!relationManager.isDirty()) continue;
            RelationData relationData = relationManager.getRelationData();
            this.deleteRelations(relationData);
            this.insertRelations(relationData);
            relationData.addedRelations.clear();
            relationData.removedRelations.clear();
            relationData.notRelatedPairs.clear();
        }
    }

    public void passivateEntity(EntityEnterpriseContext ctx) {
        this.passivateEntityCommand.execute(ctx);
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException, RemoteException {
        this.removeEntityCommand.execute(ctx);
    }

    public Collection loadRelation(JDBCCMRFieldBridge cmrField, Object pk) {
        return this.loadRelationCommand.execute(cmrField, pk);
    }

    private void deleteRelations(RelationData relationData) {
        this.deleteRelationsCommand.execute(relationData);
    }

    private void insertRelations(RelationData relationData) {
        this.insertRelationsCommand.execute(relationData);
    }

    private JDBCEntityMetaData loadJDBCEntityMetaData() throws DeploymentException {
        String ejbName;
        JDBCEntityMetaData metadata;
        ApplicationMetaData amd = this.container.getBeanMetaData().getApplicationMetaData();
        JDBCApplicationMetaData jamd = (JDBCApplicationMetaData)amd.getPluginData(CMP_JDBC);
        if (jamd == null) {
            JDBCXmlFileLoader jfl = new JDBCXmlFileLoader(amd, this.container.getClassLoader(), this.container.getLocalClassLoader(), this.log);
            jamd = jfl.load();
            amd.addPluginData(CMP_JDBC, jamd);
        }
        if ((metadata = jamd.getBeanByEjbName(ejbName = this.container.getBeanMetaData().getEjbName())) == null) {
            throw new DeploymentException("No metadata found for bean " + ejbName);
        }
        return metadata;
    }

    private final class CascadeDeleteRegistry {
        private Set scheduled;

        private CascadeDeleteRegistry() {
        }

        public void scheduleAll(List pks) {
            if (this.scheduled == null) {
                this.scheduled = new HashSet();
            }
            this.scheduled.addAll(pks);
        }

        public boolean unschedule(Object pk) {
            return this.scheduled.remove(pk);
        }
    }
}

