/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.PayloadKey;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityRolesAssociation;

public class JaasAuthenticationInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected Map securityRoles;
    protected RunAsIdentity runAsIdentity;
    protected Method ejbTimeout;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            this.securityManager = container.getSecurityManager();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (callerRunAsIdentity != null) {
            mi.setValue("RunAsIdentity", callerRunAsIdentity, PayloadKey.TRANSIENT);
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    private void checkSecurityAssociation(Invocation mi) throws Exception {
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        RunAsIdentity callerRunAsIdentity = SecurityAssociation.peekRunAsIdentity();
        if (callerRunAsIdentity == null) {
            SecurityRolesAssociation.setSecurityRoles((Map)this.securityRoles);
            Subject subject = new Subject();
            if (!this.securityManager.isValid(principal, credential, subject)) {
                Exception ex = SecurityActions.getContextException();
                if (ex != null) {
                    throw ex;
                }
                String msg = "Authentication exception, principal=" + principal;
                SecurityException e = new SecurityException(msg);
                throw e;
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            if (trace) {
                this.log.trace((Object)("Authenticated  principal=" + principal));
            }
        } else {
            SecurityActions.dupSubjectContext();
        }
    }
}

