/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.ioc.spring.SeamFactoryBean;
import org.jboss.seam.ioc.spring.SeamScopePostProcessor;
import org.jboss.seam.ioc.spring.SpringComponent;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeamNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String SEAM_SCOPE_POST_PROCESSOR = "org.jboss.seam.ioc.spring.SeamScopePostProcessor";
    public static final String SEAM_COMPONENT_POST_PROCESSOR = "org.jboss.seam.ioc.spring.SeamComponentPostProcessor";
    public static final String SEAM_COMPONENT_POST_PROCESSOR_BEAN_NAME = "org.jboss.seam.ioc.spring.seamComponentPostProcessor";

    public void init() {
        this.registerBeanDefinitionParser("configure-scopes", (BeanDefinitionParser)new SeamConfigureScopeParser());
        this.registerBeanDefinitionParser("instance", (BeanDefinitionParser)new SeamInstanceBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("component", new SeamComponentBeanDefinitionDecorator());
    }

    private static class SeamComponentBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        private static final String INTERCEPT_ATTR = "intercept";
        private static final String SPRING_NAME_ATTR = "springName";
        private static final String SEAM_NAME_ATTR = "seamName";
        private static final String BEAN_CLASS_ATTR = "beanClass";
        public static final String AUTO_INTERCEPTION_TYPE = "AUTO";

        private SeamComponentBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            ScopeType scope;
            String beanName;
            if (!parserContext.getRegistry().containsBeanDefinition(SeamNamespaceHandler.SEAM_COMPONENT_POST_PROCESSOR_BEAN_NAME)) {
                Class cls;
                try {
                    cls = ClassUtils.forName((String)SeamNamespaceHandler.SEAM_COMPONENT_POST_PROCESSOR);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load class 'org.jboss.seam.ioc.spring.SeamComponentPostProcessor' make sure you have the jboss-seam-spring.jar in your classpath.");
                }
                RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
                beanDefinition.setRole(2);
                beanDefinition.getPropertyValues().addPropertyValue("order", (Object)Integer.MAX_VALUE);
                parserContext.getRegistry().registerBeanDefinition(SeamNamespaceHandler.SEAM_COMPONENT_POST_PROCESSOR_BEAN_NAME, (BeanDefinition)beanDefinition);
            }
            String beanClassName = definition.getBeanDefinition().getBeanClassName();
            if (node.getAttributes().getNamedItem(BEAN_CLASS_ATTR) != null) {
                beanClassName = node.getAttributes().getNamedItem(BEAN_CLASS_ATTR).getNodeValue();
            }
            String seamName = beanName = definition.getBeanName();
            if (node.getAttributes().getNamedItem(SEAM_NAME_ATTR) != null) {
                seamName = node.getAttributes().getNamedItem(SEAM_NAME_ATTR).getNodeValue();
            }
            String springName = beanName;
            if (node.getAttributes().getNamedItem(SPRING_NAME_ATTR) != null) {
                springName = node.getAttributes().getNamedItem(SPRING_NAME_ATTR).getNodeValue();
            }
            InterceptionType interceptionType = null;
            if (AUTO_INTERCEPTION_TYPE.equals(node.getAttributes().getNamedItem(INTERCEPT_ATTR).getNodeValue())) {
                if (definition.getBeanDefinition().isSingleton()) {
                    interceptionType = InterceptionType.NEVER;
                }
            } else {
                interceptionType = InterceptionType.valueOf((String)node.getAttributes().getNamedItem(INTERCEPT_ATTR).getNodeValue());
            }
            if ((scope = ScopeType.valueOf((String)node.getAttributes().getNamedItem("scope").getNodeValue())) != ScopeType.STATELESS && !"prototype".equals(definition.getBeanDefinition().getScope())) {
                throw new IllegalStateException("The spring bean scope must be prototype to use a seam scope other than STATELESS.");
            }
            if (!(parserContext.getRegistry() instanceof BeanFactory)) {
                throw new RuntimeException("For some reason your registry is not a BeanFactory");
            }
            SpringComponent.addSpringComponent(seamName, springName, beanClassName, scope, (BeanFactory)parserContext.getRegistry(), interceptionType);
            return definition;
        }
    }

    private static class SeamInstanceBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private SeamInstanceBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return SeamFactoryBean.class;
        }
    }

    private static class SeamConfigureScopeParser
    extends AbstractSimpleBeanDefinitionParser {
        private SeamConfigureScopeParser() {
        }

        protected Class getBeanClass(Element element) {
            return SeamScopePostProcessor.class;
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            return SeamNamespaceHandler.SEAM_SCOPE_POST_PROCESSOR;
        }
    }
}

