/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class JGroupsTransport
extends ReceiverAdapter
implements Transport {
    Properties config = null;
    JChannel channel = null;
    Thread t = null;
    String props = null;
    String group_name = "PerfGroup";
    Receiver receiver = null;
    boolean jmx = false;

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void create(Properties properties) throws Exception {
        this.config = properties;
        this.props = this.config.getProperty("props");
        this.jmx = new Boolean(this.config.getProperty("jmx"));
        this.channel = new JChannel(this.props);
        this.channel.setReceiver(this);
    }

    public void start() throws Exception {
        this.channel.connect(this.group_name);
        if (this.jmx) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            if (servers == null || servers.size() == 0) {
                throw new Exception("No MBeanServers found;\nneeds to be run with an MBeanServer present, or inside JDK 5");
            }
            MBeanServer server = servers.get(0);
            JmxConfigurator.registerChannel(this.channel, server, "PerfTest:channel=" + this.channel.getChannelName(), true);
        }
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
        this.t = null;
    }

    public void destroy() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public Map dumpStats() {
        return this.channel != null ? this.channel.dumpStats() : null;
    }

    public void send(Object destination, byte[] payload) throws Exception {
        Message msg = new Message((Address)destination, null, payload);
        if (this.channel != null) {
            this.channel.send(msg);
        }
    }

    public void receive(Message msg) {
        Address sender = msg.getSrc();
        byte[] payload = msg.getBuffer();
        if (this.receiver != null) {
            try {
                this.receiver.receive(sender, payload);
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
    }
}

