/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapt;

import org.apache.log4j.Logger;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;

public class SenderThread
extends Thread {
    private Channel channel;
    private int num_msgs;
    private int msg_size;
    Logger log = Logger.getLogger(this.getClass());
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");

    public SenderThread(Channel ch, int num_msgs, int msg_size, long log_interval) {
        this.channel = ch;
        this.num_msgs = num_msgs;
        this.msg_size = msg_size;
        this.log_interval = log_interval;
    }

    public void run() {
        long total_msgs = 0L;
        System.out.println("Sender thread started...");
        try {
            byte[] msg = new byte[this.msg_size];
            for (int h = 0; h < this.msg_size; ++h) {
                msg[h] = (byte)h;
            }
            for (int i = 0; i < this.num_msgs; ++i) {
                Message jg_msg = new Message(null, null, msg);
                this.channel.send(jg_msg);
                if (++total_msgs % 1000L == 0L) {
                    System.out.println("++ sent " + total_msgs);
                }
                if (total_msgs % this.log_interval != 0L || this.gnuplot_output || !this.log.isInfoEnabled()) continue;
                this.log.info((Object)this.dumpStats(total_msgs));
            }
            System.out.println("Sent all messages. Sender terminates.\n");
        }
        catch (ChannelNotConnectedException e) {
            e.printStackTrace();
        }
        catch (ChannelClosedException e) {
            e.printStackTrace();
        }
    }

    String dumpStats(long sent_msgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmsgs_sent=").append(sent_msgs).append('\n');
        sb.append("free_mem=").append(Runtime.getRuntime().freeMemory());
        sb.append(" (total_mem=").append(Runtime.getRuntime().totalMemory()).append(")\n");
        return sb.toString();
    }
}

