/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.COMPRESS;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.protocols.FC;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.pbcast.STATE_TRANSFER;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class SizeTest
extends TestCase {
    public SizeTest(String name) {
        super(name);
    }

    public void testUdpHeader(Header hdr) throws Exception {
        this._testSize(new UdpHeader("DemoChannel"));
    }

    public void testTpHeader() throws Exception {
        this._testSize(new TpHeader("DemoChannel"));
    }

    public void testPingHeader() throws Exception {
        this._testSize(new PingHeader(1, null));
        IpAddress self = new IpAddress("127.0.0.1", 5555);
        PingRsp rsp = new PingRsp(self, self, true);
        this._testSize(new PingHeader(2, rsp));
    }

    public void testNakackHeader() throws Exception {
        this._testSize(new NakAckHeader(1, 322649L));
        this._testSize(new NakAckHeader(2, 100L, 104L, new IpAddress("127.0.0.1", 5655)));
        this._testSize(new NakAckHeader(3, 322649L));
    }

    public void testFdHeaders() throws Exception {
        FD.FdHeader hdr = new FD.FdHeader(1);
        this._testSize(hdr);
        IpAddress a1 = new IpAddress("127.0.0.1", 5555);
        IpAddress a2 = new IpAddress("127.0.0.1", 6666);
        Vector<IpAddress> suspects = new Vector<IpAddress>();
        suspects.add(a1);
        suspects.add(a2);
        hdr = new FD.FdHeader(2, suspects, a1);
        this._testSize(hdr);
        FD_SOCK.FdHeader sockhdr = new FD_SOCK.FdHeader(13);
        this._testSize(sockhdr);
        sockhdr = new FD_SOCK.FdHeader(10, new IpAddress("127.0.0.1", 5555));
        this._testSize(sockhdr);
        sockhdr = new FD_SOCK.FdHeader(10, suspects);
        this._testSize(sockhdr);
        Hashtable<IpAddress, IpAddress> cache = new Hashtable<IpAddress, IpAddress>();
        cache.put(a1, a2);
        cache.put(a2, a1);
        sockhdr = new FD_SOCK.FdHeader(10, cache);
        this._testSize(sockhdr);
    }

    public void testUnicastHeader() throws Exception {
        UNICAST.UnicastHeader hdr = new UNICAST.UnicastHeader(0, 322649L);
        this._testSize(hdr);
    }

    public void testStableHeader() throws Exception {
        Digest digest = new Digest(2);
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        digest.add(addr, 100L, 200L, 205L);
        STABLE.StableHeader hdr = new STABLE.StableHeader(1, digest);
        this._testSize(hdr);
        hdr = new STABLE.StableHeader(2, null);
        this._testSize(hdr);
    }

    public void testAddressVector() throws Exception {
        Vector<IpAddress> v = new Vector<IpAddress>();
        this._testSize(v);
        v.add(new IpAddress(1111));
        this._testSize(v);
        v.add(new IpAddress(2222));
        this._testSize(v);
    }

    public void testViewId() throws Exception {
        ViewId vid = new ViewId();
        this._testSize(vid);
        vid = new ViewId(new IpAddress(5555));
        this._testSize(vid);
        vid = new ViewId(new IpAddress(5555), 322649L);
        this._testSize(vid);
    }

    public void testView() throws Exception {
        View v = new View();
        this._testSize(v);
        ViewId vid = new ViewId(new IpAddress(1111), 322649L);
        Vector<IpAddress> mbrs = new Vector<IpAddress>();
        v = new View(vid, mbrs);
        this._testSize(v);
        mbrs.add(new IpAddress(3333));
        this._testSize(v);
        mbrs.add(new IpAddress(1111));
        this._testSize(v);
    }

    public void testMergeView() throws Exception {
        MergeView v = new MergeView();
        this._testSize(v);
        ViewId vid = new ViewId(new IpAddress(1111), 322649L);
        Vector<IpAddress> mbrs = new Vector<IpAddress>();
        v = new MergeView(vid, mbrs, null);
        this._testSize(v);
        mbrs.add(new IpAddress(3333));
        this._testSize(v);
        mbrs.add(new IpAddress(1111));
        this._testSize(v);
    }

    public void testMergeView2() throws Exception {
        IpAddress a = new IpAddress(1000);
        IpAddress b = new IpAddress(2000);
        IpAddress c = new IpAddress(3000);
        IpAddress d = new IpAddress(4000);
        IpAddress e = new IpAddress(5000);
        IpAddress f = new IpAddress(6000);
        Vector<IpAddress> m1 = new Vector<IpAddress>();
        Vector<IpAddress> m2 = new Vector<IpAddress>();
        Vector<IpAddress> m3 = new Vector<IpAddress>();
        Vector<IpAddress> all = new Vector<IpAddress>();
        Vector<View> subgroups = new Vector<View>();
        m1.add(a);
        m1.add(b);
        m1.add(c);
        m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, m1);
        View v2 = new View(d, 2L, m2);
        View v3 = new View(e, 3L, m3);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        this._testSize(view_all);
    }

    public void testJoinRsp() throws Exception {
        Vector<IpAddress> members = new Vector<IpAddress>();
        members.add(new IpAddress(1111));
        members.add(new IpAddress(2222));
        View v = new View(new IpAddress(1234), 322649L, members);
        Digest d = new Digest(3);
        d.add(new IpAddress(3524), 1L, 2L, 3L);
        d.add(new IpAddress(1324), 3L, 4L, 5L);
        JoinRsp rsp = new JoinRsp();
        this._testSize(rsp);
        rsp = new JoinRsp(v, d);
        this._testSize(rsp);
    }

    public void testGmsHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        GMS.GmsHeader hdr = new GMS.GmsHeader(1, addr);
        this._testSize(hdr);
        Vector<IpAddress> members = new Vector<IpAddress>();
        members.add(addr);
        members.add(addr);
        View v = new View(addr, 33L, members);
        hdr = new GMS.GmsHeader(2, v);
        this._testSize(hdr);
    }

    public void testFCHeader() throws Exception {
        FC.FcHeader hdr = new FC.FcHeader(1);
        this._testSize(hdr);
    }

    public void testFragHeader() throws Exception {
        FragHeader hdr = new FragHeader(322649L, 1, 10);
        this._testSize(hdr);
    }

    public void testCompressHeader() throws Exception {
        COMPRESS.CompressHeader hdr = new COMPRESS.CompressHeader(2002);
        this._testSize(hdr);
    }

    public void testStateHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        STATE_TRANSFER.StateHeader hdr = new STATE_TRANSFER.StateHeader(1, addr, 322649L, null);
        this._testSize(hdr);
        Digest digest = new Digest(2);
        digest.add(addr, 100L, 200L, 205L);
        digest.add(new IpAddress(2314), 102L, 104L, 105L);
        hdr = new STATE_TRANSFER.StateHeader(2, addr, 322649L, digest);
        this._testSize(hdr);
    }

    public void testEncryptHeader() throws Exception {
        ENCRYPT.EncryptHeader hdr = new ENCRYPT.EncryptHeader(1, null);
        this._testSize(hdr);
        hdr = new ENCRYPT.EncryptHeader(2, "Hello world");
        this._testSize(hdr);
    }

    public void testIpAddress() throws Exception {
        IpAddress addr = new IpAddress();
        this._testSize(addr);
    }

    public void testIpAddress1() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        this._testSize(addr);
    }

    public void testIpAddress2() throws Exception {
        IpAddress addr = new IpAddress(3456);
        this._testSize(addr);
    }

    public void testIpAddress3() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        this._testSize(addr);
    }

    public void testIpAddressWithAdditionalData() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        addr.setAdditionalData("bela".getBytes());
        this._testSize(addr);
    }

    public void testRequestCorrelatorHeader() throws Exception {
        RequestCorrelator.Header hdr = new RequestCorrelator.Header(0, 322649L, false, "HelloWorld");
        this._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        LinkedList<IpAddress> l = new LinkedList<IpAddress>();
        l.add(new IpAddress(1111));
        l.add(new IpAddress(2222));
        hdr.dest_mbrs = l;
        hdr.callStack = new Stack();
        hdr.callStack.push(new IpAddress(2222));
        hdr.callStack.push(new IpAddress(3333));
        this._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        hdr.callStack = new Stack();
        hdr.callStack.push(new IpAddress(2222));
        hdr.callStack.push(new IpAddress(3333));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        hdr.writeTo(out);
        out.flush();
        byte[] buf = output.toByteArray();
        out.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        DataInputStream in = new DataInputStream(input);
        hdr = new RequestCorrelator.Header();
        hdr.readFrom(in);
        System.out.println("call stack is " + hdr.callStack);
        Address tmp = (Address)hdr.callStack.pop();
        SizeTest.assertEquals((Object)tmp, (Object)new IpAddress(3333));
        tmp = (Address)hdr.callStack.pop();
        SizeTest.assertEquals((Object)tmp, (Object)new IpAddress(2222));
        SizeTest.assertEquals((long)hdr.id, (long)322649L);
        SizeTest.assertTrue((boolean)hdr.rsp_expected);
        SizeTest.assertEquals((String)hdr.corrName, (String)"bla");
        SizeTest.assertEquals((byte)hdr.type, (byte)1);
    }

    private void _testSize(Header hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer((Streamable)((Object)hdr));
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private void _testSize(Address addr) throws Exception {
        long size = addr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(addr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private void _testSize(ViewId vid) throws Exception {
        long size = vid.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(vid);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private void _testSize(View v) throws Exception {
        long size = v.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(v);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private void _testSize(Collection coll) throws Exception {
        long size = Util.size(coll);
        byte[] serialized_form = Util.collectionToByteBuffer(coll);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private void _testSize(JoinRsp rsp) throws Exception {
        long size = rsp.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(rsp);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    public static Test suite() {
        TestSuite s = new TestSuite(SizeTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SizeTest.suite());
    }

    static {
        try {
            ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }
}

