/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class Send {
    SynchronizedInt num_sent = new SynchronizedInt(0);
    final int NUM = 20000;

    public static void main(String[] args) throws Exception {
        new Send().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws Exception {
        MulticastSocket sock = new MulticastSocket(5555);
        byte[] buf = new byte[1000];
        InetAddress dest = InetAddress.getByName("228.5.6.7");
        sock.joinGroup(dest);
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length, dest, 5555);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 20000; ++i) {
            sock.send(packet);
            this.num_sent.increment();
        }
        long stop = System.currentTimeMillis();
        System.out.println("took " + (stop - start) + " ms (sent=" + this.num_sent + ")");
        this.num_sent.set(0);
        PooledExecutor pool = new PooledExecutor((Channel)new LinkedQueue(), 20);
        start = System.currentTimeMillis();
        for (int i = 0; i < 20000; ++i) {
            pool.execute((Runnable)new SendTask(sock, packet, this));
        }
        Send send = this;
        synchronized (send) {
            while (this.num_sent.get() < 20000) {
                this.wait(10000L);
                System.out.println("num_sent=" + this.num_sent);
            }
        }
        stop = System.currentTimeMillis();
        System.out.println("took " + (stop - start) + " ms with pool (sent=" + this.num_sent + ")");
        pool.shutdownNow();
    }

    class SendTask
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        Object mutex;

        public SendTask(DatagramSocket sock, DatagramPacket packet, Object mutex) {
            this.sock = sock;
            this.packet = packet;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: {
                try {
                    this.sock.send(this.packet);
                    if (Send.this.num_sent.increment() < 20000) break block5;
                    Object object = this.mutex;
                    synchronized (object) {
                        this.mutex.notify();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

