/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.TimeoutException;
import org.jgroups.View;

public class ChannelTest
extends TestCase {
    JChannel ch;
    private static final String GROUP = "DiscardTestGroup";

    public ChannelTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ch = new JChannel();
        this.ch.connect(GROUP);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ch.close();
    }

    public void testFirstView() throws Exception {
        Object obj = this.ch.receive(5000L);
        if (!(obj instanceof View)) {
            ChannelTest.fail((String)("first object returned needs to be a View (was " + obj + ")"));
        } else {
            System.out.println("view is " + obj);
        }
    }

    public void testReceiveTimeout() throws ChannelException, TimeoutException {
        this.ch.receive(1000L);
        try {
            this.ch.receive(2000L);
        }
        catch (ChannelNotConnectedException e) {
            ChannelTest.fail((String)"channel should be connected");
        }
        catch (ChannelClosedException e) {
            ChannelTest.fail((String)"channel should not be closed");
        }
        catch (TimeoutException e) {
            System.out.println("caught a TimeoutException - this is the expected behavior");
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite(ChannelTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ChannelTest.suite());
    }
}

