/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class ConnectionTable
implements Runnable {
    final HashMap conns = new HashMap();
    Receiver receiver = null;
    ServerSocket srv_sock = null;
    boolean reuse_addr = false;
    boolean use_send_queues = true;
    InetAddress bind_addr = null;
    InetAddress external_addr = null;
    Address local_addr = null;
    int srv_port = 7800;
    int max_port = 0;
    Thread acceptor = null;
    static final int backlog = 20;
    int recv_buf_size = 120000;
    int send_buf_size = 60000;
    final Vector conn_listeners = new Vector();
    final Object recv_mutex = new Object();
    Reaper reaper = null;
    long reaper_interval = 60000L;
    long conn_expire_time = 300000L;
    boolean use_reaper = false;
    int sock_conn_timeout = 1000;
    ThreadGroup thread_group = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    static final byte[] NULL_DATA = new byte[0];
    final byte[] cookie = new byte[]{98, 101, 108, 97};

    public ConnectionTable(int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTable(InetAddress bind_addr, int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.bind_addr = bind_addr;
        this.start();
    }

    public ConnectionTable(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.srv_port = srv_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public ConnectionTable(Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.start();
    }

    public ConnectionTable(Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.external_addr = external_addr;
        this.srv_port = srv_port;
        this.max_port = max_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void addConnectionListener(ConnectionListener l) {
        if (l != null && !this.conn_listeners.contains(l)) {
            this.conn_listeners.addElement(l);
        }
    }

    public void removeConnectionListener(ConnectionListener l) {
        if (l != null) {
            this.conn_listeners.removeElement(l);
        }
    }

    public Address getLocalAddress() {
        if (this.local_addr == null) {
            this.local_addr = this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_port) : null;
        }
        return this.local_addr;
    }

    public int getSendBufferSize() {
        return this.send_buf_size;
    }

    public void setSendBufferSize(int send_buf_size) {
        this.send_buf_size = send_buf_size;
    }

    public int getReceiveBufferSize() {
        return this.recv_buf_size;
    }

    public void setReceiveBufferSize(int recv_buf_size) {
        this.recv_buf_size = recv_buf_size;
    }

    public int getSocketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public int getNumConnections() {
        return this.conns.size();
    }

    public boolean getUseSendQueues() {
        return this.use_send_queues;
    }

    public void setUseSendQueues(boolean flag) {
        this.use_send_queues = flag;
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        Connection conn;
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"destination is null");
            }
            return;
        }
        if (data == null) {
            this.log.warn((Object)"data is null; discarding packet");
            return;
        }
        try {
            conn = this.getConnection(dest);
            if (conn == null) {
                return;
            }
        }
        catch (Throwable ex) {
            throw new Exception("connection to " + dest + " could not be established", ex);
        }
        try {
            conn.send(data, offset, length);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("sending msg to " + dest + " failed (" + ex.getClass().getName() + "); removing from connection table"));
            }
            this.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(Address dest) throws Exception {
        Connection conn = null;
        HashMap hashMap = this.conns;
        synchronized (hashMap) {
            conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                Socket sock;
                block10: {
                    block9: {
                        InetSocketAddress tmpBindAddr = new InetSocketAddress(this.bind_addr, 0);
                        InetAddress tmpDest = ((IpAddress)dest).getIpAddress();
                        InetSocketAddress destAddr = new InetSocketAddress(tmpDest, ((IpAddress)dest).getPort());
                        sock = new Socket();
                        sock.bind(tmpBindAddr);
                        sock.connect(destAddr, this.sock_conn_timeout);
                        try {
                            sock.setSendBufferSize(this.send_buf_size);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block9;
                            this.log.error((Object)("exception setting send buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                        }
                    }
                    try {
                        sock.setReceiveBufferSize(this.recv_buf_size);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isErrorEnabled()) break block10;
                        this.log.error((Object)("exception setting receive buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                    }
                }
                conn = new Connection(sock, dest);
                conn.sendLocalAddress(this.local_addr);
                this.notifyConnectionOpened(dest);
                this.addConnection(dest, conn);
                conn.init();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("created socket to " + dest));
                }
            }
            return conn;
        }
    }

    public void start() throws Exception {
        this.init();
        this.srv_sock = this.createServerSocket(this.srv_port, this.max_port);
        this.local_addr = this.external_addr != null ? new IpAddress(this.external_addr, this.srv_sock.getLocalPort()) : (this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("server socket created on " + this.local_addr));
        }
        this.thread_group = new ThreadGroup(Thread.currentThread().getThreadGroup(), "ConnectionTableGroup");
        this.acceptor = new Thread(this.thread_group, this, "ConnectionTable.AcceptorThread");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
        if (this.use_reaper && this.reaper == null) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
    }

    protected void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Iterator it = null;
        if (this.srv_sock != null) {
            try {
                ServerSocket tmp = this.srv_sock;
                this.srv_sock = null;
                tmp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap hashMap = this.conns;
        synchronized (hashMap) {
            it = this.conns.values().iterator();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                conn.destroy();
            }
            this.conns.clear();
        }
        this.local_addr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address addr) {
        Connection conn;
        HashMap hashMap = this.conns;
        synchronized (hashMap) {
            conn = (Connection)this.conns.remove(addr);
        }
        if (conn != null) {
            try {
                conn.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removed " + addr + ", connections are " + this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection conn = null;
        while (this.srv_sock != null) {
            try {
                Socket client_sock;
                block20: {
                    block19: {
                        client_sock = this.srv_sock.accept();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("accepted connection from " + client_sock.getInetAddress() + ":" + client_sock.getPort()));
                        }
                        try {
                            client_sock.setSendBufferSize(this.send_buf_size);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block19;
                            this.log.error((Object)("exception setting send buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                        }
                    }
                    try {
                        client_sock.setReceiveBufferSize(this.recv_buf_size);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isErrorEnabled()) break block20;
                        this.log.error((Object)("exception setting receive buffer size to " + this.send_buf_size + " bytes"), (Throwable)ex);
                    }
                }
                conn = new Connection(client_sock, null);
                Address peer_addr = conn.readPeerAddress(client_sock);
                conn.setPeerAddress(peer_addr);
                HashMap ex = this.conns;
                synchronized (ex) {
                    if (this.conns.containsKey(peer_addr)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(peer_addr + " is already there, will reuse connection"));
                        }
                    } else {
                        this.addConnection(peer_addr, conn);
                        this.notifyConnectionOpened(peer_addr);
                    }
                }
                conn.init();
            }
            catch (SocketException sock_ex) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("exception is " + sock_ex));
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (Throwable ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("exception is " + ex));
                }
                if (this.srv_sock != null) continue;
                break;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(Thread.currentThread().getName() + " terminated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Address sender, byte[] data, int offset, int length) {
        if (this.receiver != null) {
            Object object = this.recv_mutex;
            synchronized (object) {
                this.receiver.receive(sender, data, offset, length);
            }
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)"receiver is null (not set) !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap copy;
        StringBuffer ret = new StringBuffer();
        HashMap hashMap = this.conns;
        synchronized (hashMap) {
            copy = new HashMap(this.conns);
        }
        ret.append("connections (" + copy.size() + "):\n");
        Iterator it = copy.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address key = (Address)entry.getKey();
            Connection val = (Connection)entry.getValue();
            ret.append("key: " + key + ": " + val + '\n');
        }
        ret.append('\n');
        return ret.toString();
    }

    protected ServerSocket createServerSocket(int start_port, int end_port) throws Exception {
        ServerSocket ret = null;
        while (true) {
            try {
                if (this.bind_addr == null) {
                    ret = new ServerSocket(start_port);
                    break;
                }
                ret = new ServerSocket(start_port, 20, this.bind_addr);
            }
            catch (BindException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to");
                }
                if (this.bind_addr != null && (nic = NetworkInterface.getByInetAddress(this.bind_addr)) == null) {
                    throw new BindException("bind_addr " + this.bind_addr + " is not a valid interface");
                }
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        this.srv_port = start_port;
        return ret;
    }

    void notifyConnectionOpened(Address peer) {
        if (peer == null) {
            return;
        }
        for (int i = 0; i < this.conn_listeners.size(); ++i) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionOpened(peer);
        }
    }

    void notifyConnectionClosed(Address peer) {
        if (peer == null) {
            return;
        }
        for (int i = 0; i < this.conn_listeners.size(); ++i) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionClosed(peer);
        }
    }

    void addConnection(Address peer, Connection c) {
        this.conns.put(peer, c);
        if (this.reaper != null && !this.reaper.isRunning()) {
            this.reaper.start();
        }
    }

    class Reaper
    implements Runnable {
        Thread t = null;

        Reaper() {
        }

        public void start() {
            if (ConnectionTable.this.conns.size() == 0) {
                return;
            }
            if (this.t != null && !this.t.isAlive()) {
                this.t = null;
            }
            if (this.t == null) {
                this.t = new Thread(ConnectionTable.this.thread_group, this, "ConnectionTable.ReaperThread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            if (this.t != null) {
                this.t = null;
            }
        }

        public boolean isRunning() {
            return this.t != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ConnectionTable.this.log.isInfoEnabled()) {
                ConnectionTable.this.log.info((Object)("connection reaper thread was started. Number of connections=" + ConnectionTable.this.conns.size() + ", reaper_interval=" + ConnectionTable.this.reaper_interval + ", conn_expire_time=" + ConnectionTable.this.conn_expire_time));
            }
            while (ConnectionTable.this.conns.size() > 0 && this.t != null && this.t.equals(Thread.currentThread())) {
                Util.sleep(ConnectionTable.this.reaper_interval);
                HashMap hashMap = ConnectionTable.this.conns;
                synchronized (hashMap) {
                    long curr_time = System.currentTimeMillis();
                    Iterator it = ConnectionTable.this.conns.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Connection value = (Connection)entry.getValue();
                        if (ConnectionTable.this.log.isInfoEnabled()) {
                            ConnectionTable.this.log.info((Object)("connection is " + (curr_time - value.last_access) / 1000L + " seconds old (curr-time=" + curr_time + ", last_access=" + value.last_access + ')'));
                        }
                        if (value.last_access + ConnectionTable.this.conn_expire_time >= curr_time) continue;
                        if (ConnectionTable.this.log.isInfoEnabled()) {
                            ConnectionTable.this.log.info((Object)("connection " + value + " has been idle for too long (conn_expire_time=" + ConnectionTable.this.conn_expire_time + "), will be removed"));
                        }
                        value.destroy();
                        it.remove();
                    }
                }
            }
            if (ConnectionTable.this.log.isInfoEnabled()) {
                ConnectionTable.this.log.info((Object)"reaper terminated");
            }
            this.t = null;
        }
    }

    class Connection
    implements Runnable {
        Socket sock;
        String sock_addr;
        DataOutputStream out;
        DataInputStream in;
        Thread receiverThread;
        Address peer_addr;
        final Object send_mutex;
        long last_access;
        Queue send_queue;
        Sender sender;

        private String getSockAddress() {
            if (this.sock_addr != null) {
                return this.sock_addr;
            }
            if (this.sock != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
                sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
                this.sock_addr = sb.toString();
            }
            return this.sock_addr;
        }

        Connection(Socket s, Address peer_addr) {
            block2: {
                this.sock = null;
                this.sock_addr = null;
                this.out = null;
                this.in = null;
                this.receiverThread = null;
                this.peer_addr = null;
                this.send_mutex = new Object();
                this.last_access = System.currentTimeMillis();
                this.send_queue = new Queue();
                this.sender = new Sender();
                this.sock = s;
                this.peer_addr = peer_addr;
                try {
                    this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                    this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                }
                catch (Exception ex) {
                    if (!ConnectionTable.this.log.isErrorEnabled()) break block2;
                    ConnectionTable.this.log.error((Object)("exception is " + ex));
                }
            }
        }

        boolean established() {
            return this.receiverThread != null;
        }

        void setPeerAddress(Address peer_addr) {
            this.peer_addr = peer_addr;
        }

        Address getPeerAddress() {
            return this.peer_addr;
        }

        void updateLastAccessed() {
            this.last_access = System.currentTimeMillis();
        }

        void init() {
            if (this.receiverThread == null || !this.receiverThread.isAlive()) {
                this.receiverThread = new Thread(ConnectionTable.this.thread_group, this, "ConnectionTable.Connection.Receiver [" + this.getSockAddress() + "]");
                this.receiverThread.setDaemon(true);
                this.receiverThread.start();
                if (ConnectionTable.this.log.isTraceEnabled()) {
                    ConnectionTable.this.log.trace((Object)"ConnectionTable.Connection.Receiver started");
                }
            }
        }

        void destroy() {
            this.closeSocket();
            this.sender.stop();
            this.receiverThread = null;
        }

        void send(byte[] data, int offset, int length) {
            if (ConnectionTable.this.use_send_queues) {
                try {
                    if (data != null) {
                        byte[] tmp = new byte[length];
                        System.arraycopy(data, offset, tmp, 0, length);
                        this.send_queue.add(tmp);
                    } else {
                        this.send_queue.add(NULL_DATA);
                    }
                    if (!this.sender.isRunning()) {
                        this.sender.start();
                    }
                }
                catch (QueueClosedException e) {
                    ConnectionTable.this.log.error((Object)"failed adding message to send_queue", (Throwable)e);
                }
            } else {
                this._send(data, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _send(byte[] data, int offset, int length) {
            Object object = this.send_mutex;
            synchronized (object) {
                block12: {
                    try {
                        this.doSend(data, offset, length);
                        this.updateLastAccessed();
                    }
                    catch (IOException io_ex) {
                        if (ConnectionTable.this.log.isWarnEnabled()) {
                            ConnectionTable.this.log.warn((Object)"peer closed connection, trying to re-establish connection and re-send msg");
                        }
                        try {
                            this.doSend(data, offset, length);
                            this.updateLastAccessed();
                        }
                        catch (IOException io_ex2) {
                            if (ConnectionTable.this.log.isErrorEnabled()) {
                                ConnectionTable.this.log.error((Object)"2nd attempt to send data failed too");
                            }
                        }
                        catch (Exception ex2) {
                            if (ConnectionTable.this.log.isErrorEnabled()) {
                                ConnectionTable.this.log.error((Object)("exception is " + ex2));
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!ConnectionTable.this.log.isErrorEnabled()) break block12;
                        ConnectionTable.this.log.error((Object)("exception is " + ex));
                    }
                }
            }
        }

        void doSend(byte[] data, int offset, int length) throws Exception {
            try {
                if (this.out != null) {
                    this.out.writeInt(length);
                    Util.doubleWrite(data, offset, length, this.out);
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                if (ConnectionTable.this.log.isErrorEnabled()) {
                    ConnectionTable.this.log.error((Object)("failure sending to " + this.peer_addr), (Throwable)ex);
                }
                ConnectionTable.this.remove(this.peer_addr);
                throw ex;
            }
        }

        Address readPeerAddress(Socket client_sock) throws Exception {
            InetAddress client_addr;
            IpAddress client_peer_addr = null;
            byte[] input_cookie = new byte[ConnectionTable.this.cookie.length];
            int client_port = client_sock != null ? client_sock.getPort() : 0;
            InetAddress inetAddress = client_addr = client_sock != null ? client_sock.getInetAddress() : null;
            if (this.in != null) {
                this.initCookie(input_cookie);
                this.in.read(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionTable.Connection.readPeerAddress(): cookie sent by " + client_peer_addr + " does not match own cookie; terminating connection");
                }
                short version = this.in.readShort();
                if (!Version.compareTo(version) && ConnectionTable.this.log.isWarnEnabled()) {
                    ConnectionTable.this.log.warn((Object)new StringBuffer("packet from ").append(client_addr).append(':').append(client_port).append(" has different version (").append(version).append(") from ours (").append(2291).append("). This may cause problems"));
                }
                client_peer_addr = new IpAddress();
                client_peer_addr.readFrom(this.in);
                this.updateLastAccessed();
            }
            return client_peer_addr;
        }

        void sendLocalAddress(Address local_addr) {
            block5: {
                if (local_addr == null) {
                    if (ConnectionTable.this.log.isWarnEnabled()) {
                        ConnectionTable.this.log.warn((Object)"local_addr is null");
                    }
                    return;
                }
                if (this.out != null) {
                    try {
                        this.out.write(ConnectionTable.this.cookie, 0, ConnectionTable.this.cookie.length);
                        this.out.writeShort(2291);
                        local_addr.writeTo(this.out);
                        this.out.flush();
                        this.updateLastAccessed();
                    }
                    catch (Throwable t) {
                        if (!ConnectionTable.this.log.isErrorEnabled()) break block5;
                        ConnectionTable.this.log.error((Object)("exception is " + t));
                    }
                }
            }
        }

        void initCookie(byte[] c) {
            if (c != null) {
                for (int i = 0; i < c.length; ++i) {
                    c[i] = 0;
                }
            }
        }

        boolean matchCookie(byte[] input) {
            if (input == null || input.length < ConnectionTable.this.cookie.length) {
                return false;
            }
            if (ConnectionTable.this.log.isInfoEnabled()) {
                ConnectionTable.this.log.info((Object)("input_cookie is " + this.printCookie(input)));
            }
            for (int i = 0; i < ConnectionTable.this.cookie.length; ++i) {
                if (ConnectionTable.this.cookie[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        String printCookie(byte[] c) {
            if (c == null) {
                return "";
            }
            return new String(c);
        }

        public void run() {
            byte[] buf = new byte[256];
            int len = 0;
            while (this.receiverThread != null && this.receiverThread.equals(Thread.currentThread())) {
                try {
                    if (this.in == null) {
                        if (!ConnectionTable.this.log.isErrorEnabled()) break;
                        ConnectionTable.this.log.error((Object)"input stream is null !");
                        break;
                    }
                    len = this.in.readInt();
                    if (len > buf.length) {
                        buf = new byte[len];
                    }
                    this.in.readFully(buf, 0, len);
                    this.updateLastAccessed();
                    ConnectionTable.this.receive(this.peer_addr, buf, 0, len);
                }
                catch (OutOfMemoryError mem_ex) {
                    if (!ConnectionTable.this.log.isWarnEnabled()) break;
                    ConnectionTable.this.log.warn((Object)"dropped invalid message, closing connection");
                    break;
                }
                catch (EOFException eof_ex) {
                    if (ConnectionTable.this.log.isInfoEnabled()) {
                        ConnectionTable.this.log.info((Object)("exception is " + eof_ex));
                    }
                    ConnectionTable.this.notifyConnectionClosed(this.peer_addr);
                    break;
                }
                catch (IOException io_ex) {
                    if (ConnectionTable.this.log.isInfoEnabled()) {
                        ConnectionTable.this.log.info((Object)("exception is " + io_ex));
                    }
                    ConnectionTable.this.notifyConnectionClosed(this.peer_addr);
                    break;
                }
                catch (Throwable e) {
                    if (!ConnectionTable.this.log.isWarnEnabled()) continue;
                    ConnectionTable.this.log.warn((Object)("exception is " + e));
                }
            }
            if (ConnectionTable.this.log.isTraceEnabled()) {
                ConnectionTable.this.log.trace((Object)"ConnectionTable.Connection.Receiver terminated");
            }
            this.receiverThread = null;
            this.closeSocket();
            ConnectionTable.this.remove(this.peer_addr);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            InetAddress local = null;
            InetAddress remote = null;
            if (this.sock == null) {
                ret.append("<null socket>");
            } else {
                Socket tmp_sock = this.sock;
                local = tmp_sock.getLocalAddress();
                remote = tmp_sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local) : "<null>";
                String remote_str = remote != null ? Util.shortName(remote) : "<null>";
                ret.append('<' + local_str + ':' + tmp_sock.getLocalPort() + " --> " + remote_str + ':' + tmp_sock.getPort() + "> (" + (System.currentTimeMillis() - this.last_access) / 1000L + " secs old)");
                tmp_sock = null;
            }
            return ret.toString();
        }

        void closeSocket() {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sock = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in = null;
            }
        }

        class Sender
        implements Runnable {
            Thread senderThread;
            private boolean running = false;

            Sender() {
            }

            void start() {
                if (this.senderThread == null || !this.senderThread.isAlive()) {
                    this.senderThread = new Thread(((Connection)Connection.this).ConnectionTable.this.thread_group, this, "ConnectionTable.Connection.Sender [" + Connection.this.getSockAddress() + "]");
                    this.senderThread.setDaemon(true);
                    this.senderThread.start();
                    this.running = true;
                    if (((Connection)Connection.this).ConnectionTable.this.log.isTraceEnabled()) {
                        ((Connection)Connection.this).ConnectionTable.this.log.trace((Object)"ConnectionTable.Connection.Sender thread started");
                    }
                }
            }

            void stop() {
                if (this.senderThread != null) {
                    this.senderThread.interrupt();
                    this.senderThread = null;
                    this.running = false;
                }
            }

            boolean isRunning() {
                return this.running && this.senderThread != null;
            }

            public void run() {
                while (this.senderThread != null && this.senderThread.equals(Thread.currentThread())) {
                    try {
                        byte[] data = (byte[])Connection.this.send_queue.remove();
                        if (data == null) continue;
                        Connection.this._send(data, 0, data.length);
                    }
                    catch (QueueClosedException e) {
                        // empty catch block
                        break;
                    }
                }
                this.running = false;
                if (((Connection)Connection.this).ConnectionTable.this.log.isTraceEnabled()) {
                    ((Connection)Connection.this).ConnectionTable.this.log.trace((Object)"ConnectionTable.Connection.Sender thread terminated");
                }
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionOpened(Address var1);

        public void connectionClosed(Address var1);
    }

    public static interface Receiver {
        public void receive(Address var1, byte[] var2, int var3, int var4);
    }
}

