/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XOPSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(XOPSerializer.class);

    public String serialize(QName xmlName, QName xmlType, Object value, SerializationContextImpl serContext, NamedNodeMap attributes) throws BindingException {
        AttachmentPart xopPart;
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        StringBuilder xopInclude = new StringBuilder("<xop:Include ");
        xopInclude.append("xmlns:xop='http://www.w3.org/2004/08/xop/include' ");
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getMessage();
        String cid = soapMessage.getCidGenerator().generateFromName(xmlName.getLocalPart());
        xopInclude.append("href='" + cid + "'/>");
        Node attr = attributes.getNamedItemNS("http://www.w3.org/2004/11/xmlmime", "contentType");
        if (attr == null) {
            throw new WSException("Cannot obtain xmime:contentType");
        }
        String contentType = attr.getNodeValue();
        if (value instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)value;
            xopPart = soapMessage.createAttachmentPart(dataHandler);
            if (!contentType.equals(dataHandler.getContentType())) {
                log.warn((Object)("ContentType missmatch " + contentType + "!=" + dataHandler.getContentType()));
            }
        } else {
            xopPart = soapMessage.createAttachmentPart(value, contentType);
        }
        xopPart.addMimeHeader("Content-Id", cid);
        soapMessage.addAttachmentPart(xopPart);
        String xmlFragment = this.wrapValueStr(xmlName, xopInclude.toString(), nsRegistry, attributes);
        return xmlFragment;
    }
}

