/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.addressing.soap;

import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.addressing.AddressingConstantsImpl;
import org.jboss.ws.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.soap.SOAPMessageContextImpl;

public class SOAPServerHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(SOAPServerHandler.class);
    private boolean validate = true;
    private HandlerInfo handlerInfo;
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;

    public QName[] getHeaders() {
        return new QName[0];
    }

    public void init(HandlerInfo handlerInfo) {
        String validateParam;
        super.init(handlerInfo);
        this.handlerInfo = handlerInfo;
        String string = validateParam = handlerInfo.getHandlerConfig().get("validate") != null ? (String)handlerInfo.getHandlerConfig().get("validate") : Boolean.TRUE.toString();
        if (Boolean.FALSE.toString().equals(validateParam)) {
            this.validate = false;
        }
    }

    public boolean handleRequest(MessageContext msgContext) {
        log.debug((Object)"handleRequest");
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        addrProps.readHeaders(soapMessage);
        msgContext.setProperty("javax.xml.ws.addressing.context.inbound", (Object)addrProps);
        if (this.validate) {
            this.validateRequest(addrProps);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        log.debug((Object)"handleRequest");
        this.handleResponseOrFault(msgContext, false);
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        log.debug((Object)"handleFault");
        this.handleResponseOrFault(msgContext, true);
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.setProperty("javax.xml.ws.addressing.context.outbound", (Object)outProps);
        }
        outProps.initializeAsReply(inProps, isFault);
        try {
            OperationMetaData opMetaData = ((SOAPMessageContextImpl)msgContext).getOperationMetaData();
            if (!isFault && !opMetaData.isOneWayOperation()) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null) {
                    outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
                } else {
                    log.warn((Object)("Unable to resolve replyAction for " + opMetaData.getXmlName()));
                }
            } else if (isFault) {
                outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error setting response action", (Throwable)e);
        }
        outProps.writeHeaders(soapMessage);
    }

    private void validateRequest(SOAPAddressingProperties addrProps) {
        if (addrProps.getReplyTo() != null && addrProps.getMessageID() == null) {
            throw new IllegalArgumentException("wsa:MessageId is required when wsa:ReplyTo is supplied");
        }
    }

    static {
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
    }
}

