/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.Arrays;
import org.drools.RuntimeDroolsException;

public class PackageBuilderConfiguration {
    public static final int ECLIPSE = 0;
    public static final int JANINO = 1;
    public static final String[] LANGUAGE_LEVELS = new String[]{"1.4", "1.5", "1.6"};
    public static final String DEFAULT_LANGUAGE_LEVEL = "1.4";
    private static final int CONFIGURED_COMPILER = PackageBuilderConfiguration.getDefaultCompiler();
    private static final String CONFIGURED_LANGUAGE_LEVEL = PackageBuilderConfiguration.getDefaultLanguageLevel();
    private int compiler = CONFIGURED_COMPILER;
    private ClassLoader classLoader;
    private String languageLevel = CONFIGURED_LANGUAGE_LEVEL;

    public PackageBuilderConfiguration() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public int getCompiler() {
        return this.compiler;
    }

    public String getJavaLanguageLevel() {
        if (this.languageLevel != null) {
            return this.languageLevel;
        }
        this.languageLevel = System.getProperty("drools.compiler.lnglevel", DEFAULT_LANGUAGE_LEVEL);
        if (Arrays.binarySearch(LANGUAGE_LEVELS, this.languageLevel) < 0) {
            throw new RuntimeDroolsException("value '" + this.languageLevel + "' is not a valid language level");
        }
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String string) {
        this.languageLevel = string;
    }

    public void setCompiler(int n) {
        switch (n) {
            case 0: {
                this.compiler = 0;
                break;
            }
            case 1: {
                this.compiler = 1;
                break;
            }
            default: {
                throw new RuntimeDroolsException("value '" + n + "' is not a valid compiler");
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    static int getDefaultCompiler() {
        try {
            String string = System.getProperty("drools.compiler", "ECLIPSE");
            if (string.equals("ECLIPSE".intern())) {
                return 0;
            }
            if (string.equals("JANINO")) {
                return 1;
            }
            System.err.println("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + string);
            return 0;
        }
        catch (SecurityException securityException) {
            System.err.println("Drools config: unable to read the drools.compiler property. Using default.");
            return 0;
        }
    }

    static String getDefaultLanguageLevel() {
        try {
            String string = System.getProperty("drools.compiler.languagelevel", DEFAULT_LANGUAGE_LEVEL);
            if (Arrays.binarySearch(LANGUAGE_LEVELS, string) < 0) {
                throw new RuntimeDroolsException("value '" + string + "' is not a valid language level");
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return DEFAULT_LANGUAGE_LEVEL;
        }
    }
}

