/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLWrapperFactory;
import org.apache.commons.ssl.TrustChain;

public class SSLClient
extends SSLSocketFactory {
    private final SSL ssl = new SSL();

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.addTrustMaterial(trustChain);
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setTrustMaterial(trustChain);
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setKeyMaterial(keyMaterial);
    }

    public String[] getEnabledCiphers() {
        return this.ssl.getEnabledCiphers();
    }

    public void setEnabledCiphers(String[] ciphers) throws IllegalArgumentException {
        this.ssl.setEnabledCiphers(ciphers);
    }

    public String[] getEnabledProtocols() {
        return this.ssl.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.ssl.setEnabledProtocols(protocols);
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.ssl.setCheckExpiry(checkExpiry);
    }

    public boolean getCheckExpiry() {
        return this.ssl.getCheckExpiry();
    }

    public void setCheckHostname(boolean checkHostname) {
        this.ssl.setCheckHostname(checkHostname);
    }

    public boolean getCheckHostname() {
        return this.ssl.getCheckHostname();
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.ssl.getAssociatedCertificateChain();
    }

    public void setCheckCRL(boolean checkCRL) {
        this.ssl.setCheckCRL(checkCRL);
    }

    public boolean getCheckCRL() {
        return this.ssl.getCheckCRL();
    }

    public void setSoTimeout(int soTimeout) {
        this.ssl.setSoTimeout(soTimeout);
    }

    public void setUseClientMode(boolean useClientMode) {
        this.ssl.setUseClientMode(useClientMode);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.ssl.setConnectTimeout(connectTimeout);
    }

    public void setDefaultProtocol(String protocol) {
        this.ssl.setDefaultProtocol(protocol);
    }

    public String[] getDefaultCipherSuites() {
        return this.ssl.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.ssl.getSupportedCipherSuites();
    }

    public TrustChain getTrustChain() {
        return this.ssl.getTrustChain();
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.ssl.getSSLWrapperFactory();
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.ssl.setSSLWrapperFactory(wf);
    }

    public Socket createSocket() throws IOException {
        return this.ssl.createSocket();
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.ssl.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getHostName(), port);
    }

    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host.getHostName(), port, localHost, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host, port, localHost, localPort, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, int timeout) throws IOException {
        return this.ssl.createSocket(host, port, localHost, localPort, timeout);
    }

    public Socket createSocket(Socket s, String remoteHost, int remotePort, boolean autoClose) throws IOException {
        return this.ssl.createSocket(s, remoteHost, remotePort, autoClose);
    }

    public X509Certificate[] getCurrentServerChain() {
        return this.ssl.getCurrentServerChain();
    }
}

