/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;

public class DateDecoder
implements DataDecoder {
    public static final String FORMAT_CONFIG_KEY = "format";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private String format = "yyyy-MM-dd'T'HH:mm:ss";
    private SimpleDateFormat decoder = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        this.format = resourceConfig.getStringParameter(FORMAT_CONFIG_KEY, DEFAULT_DATE_FORMAT);
        this.decoder = new SimpleDateFormat(this.format.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(String data) throws DataDecodeException {
        try {
            SimpleDateFormat simpleDateFormat = this.decoder;
            synchronized (simpleDateFormat) {
                return this.decoder.parse(data.trim());
            }
        }
        catch (ParseException e) {
            throw new DataDecodeException("Error decoding Date data value '" + data + "' with decode format '" + this.format + "'.", e);
        }
    }
}

