/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.stringtemplate;

import java.util.HashMap;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.delivery.dom.serialize.ContextObjectSerializationUnit;
import org.milyn.javabean.BeanAccessor;
import org.milyn.templating.AbstractTemplateProcessingUnit;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StringTemplateContentDeliveryUnitCreator
implements ContentDeliveryUnitCreator {
    public StringTemplateContentDeliveryUnitCreator(SmooksResourceConfiguration config) {
    }

    public synchronized ContentDeliveryUnit create(SmooksResourceConfiguration resourceConfig) throws InstantiationException {
        try {
            StringTemplateProcessingUnit processingUnit = new StringTemplateProcessingUnit();
            processingUnit.setConfiguration(resourceConfig);
            return processingUnit;
        }
        catch (SmooksConfigurationException e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    private static class StringTemplateProcessingUnit
    extends AbstractTemplateProcessingUnit {
        private StringTemplate template;

        private StringTemplateProcessingUnit() {
        }

        protected void loadTemplate(SmooksResourceConfiguration config) {
            String path = config.getResource();
            String encoding = config.getStringParameter("encoding", "UTF-8");
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.endsWith(".st")) {
                path = path.substring(0, path.length() - 3);
            }
            StringTemplateGroup templateGroup = new StringTemplateGroup(path);
            templateGroup.setFileCharEncoding(encoding);
            this.template = templateGroup.getInstanceOf(path);
        }

        protected void visit(Element element, ExecutionContext executionContext) {
            Node resultNode;
            StringTemplate thisTransTemplate = this.template.getInstanceOf();
            HashMap beans = BeanAccessor.getBeans((ExecutionContext)executionContext);
            thisTransTemplate.setAttributes((Map)beans);
            String templatingResult = thisTransTemplate.toString();
            if (this.getAction() != AbstractTemplateProcessingUnit.Action.ADDTO && element == element.getOwnerDocument().getDocumentElement()) {
                String key = "StringTemplateObject:" + DomUtils.getXPath((Node)element);
                executionContext.setAttribute((Object)key, (Object)templatingResult);
                resultNode = ContextObjectSerializationUnit.createElement((Document)element.getOwnerDocument(), (String)key);
            } else {
                resultNode = element.getOwnerDocument().createTextNode(templatingResult);
            }
            this.processTemplateAction(element, resultNode);
        }
    }
}

