/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.delivery.dom.serialize.ContextObjectSerializationUnit;
import org.milyn.javabean.BeanAccessor;
import org.milyn.templating.AbstractTemplateProcessingUnit;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeMarkerContentDeliveryUnitCreator
implements ContentDeliveryUnitCreator {
    public FreeMarkerContentDeliveryUnitCreator(SmooksResourceConfiguration config) {
    }

    public synchronized ContentDeliveryUnit create(SmooksResourceConfiguration resourceConfig) throws InstantiationException {
        try {
            FreeMarkerProcessingUnit processingUnit = new FreeMarkerProcessingUnit();
            processingUnit.setConfiguration(resourceConfig);
            return processingUnit;
        }
        catch (SmooksConfigurationException e) {
            InstantiationException instanceException = new InstantiationException("FreeMarker resource [" + resourceConfig.getResource() + "] not loadable.  FreeMarker resource invalid.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    private static class FreeMarkerProcessingUnit
    extends AbstractTemplateProcessingUnit {
        private static Log logger = LogFactory.getLog(FreeMarkerProcessingUnit.class);
        private Template template;
        private SmooksResourceConfiguration config;

        private FreeMarkerProcessingUnit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadTemplate(SmooksResourceConfiguration config) throws IOException {
            byte[] templateBytes = config.getBytes();
            String encoding = config.getStringParameter("encoding", "UTF-8");
            InputStreamReader templateReader = new InputStreamReader((InputStream)new ByteArrayInputStream(templateBytes), encoding);
            try {
                this.config = config;
                this.template = new Template("free-marker-template", (Reader)templateReader, new Configuration());
            }
            finally {
                ((Reader)templateReader).close();
            }
        }

        protected void visit(Element element, ExecutionContext executionContext) {
            Node resultNode;
            HashMap beans = BeanAccessor.getBeans((ExecutionContext)executionContext);
            StringWriter writer = new StringWriter();
            try {
                this.template.process((Object)beans, (Writer)writer);
            }
            catch (TemplateException e) {
                logger.warn((Object)("Failed to apply FreeMarker template to fragment '" + DomUtils.getXPath((Node)element) + "'.  Resource: " + this.config), (Throwable)e);
                return;
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to apply FreeMarker template to fragment '" + DomUtils.getXPath((Node)element) + "'.  Resource: " + this.config), (Throwable)e);
                return;
            }
            String templatingResult = ((Object)writer).toString();
            if (this.getAction() != AbstractTemplateProcessingUnit.Action.ADDTO && element == element.getOwnerDocument().getDocumentElement()) {
                String key = "FreeMarkerObject:" + DomUtils.getXPath((Node)element);
                executionContext.setAttribute((Object)key, (Object)templatingResult);
                resultNode = ContextObjectSerializationUnit.createElement((Document)element.getOwnerDocument(), (String)key);
            } else {
                resultNode = element.getOwnerDocument().createTextNode(templatingResult);
            }
            this.processTemplateAction(element, resultNode);
        }
    }
}

