/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating;

import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTemplateProcessingUnit
implements DOMElementVisitor {
    private Log logger;
    private boolean visitBefore = false;
    private Action action = Action.REPLACE;

    public void setConfiguration(SmooksResourceConfiguration config) throws SmooksConfigurationException {
        this.logger = LogFactory.getLog(this.getClass());
        this.visitBefore = config.getBoolParameter("visitBefore", false);
        this.setAction(config);
        try {
            this.loadTemplate(config);
        }
        catch (IOException e) {
            this.logger.error((Object)("Error loading Templating resource: " + config), (Throwable)e);
            throw new SmooksConfigurationException("Unable to read template.", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            this.logger.error((Object)("Error loading Templating resource: " + config), (Throwable)e);
            throw new SmooksConfigurationException("Unable to configure template engine.", (Throwable)e);
        }
    }

    protected abstract void loadTemplate(SmooksResourceConfiguration var1) throws IOException, TransformerConfigurationException;

    private void setAction(SmooksResourceConfiguration config) {
        String actionParam = config.getStringParameter("action");
        this.action = "addto".equals(actionParam) ? Action.ADDTO : ("insertbefore".equals(actionParam) ? Action.INSERT_BEFORE : ("insertafter".equals(actionParam) ? Action.INSERT_AFTER : Action.REPLACE));
    }

    protected Action getAction() {
        return this.action;
    }

    protected void processTemplateAction(Element element, Node templatingResult) {
        if (this.action == Action.REPLACE) {
            DomUtils.replaceNode((Node)templatingResult, (Node)element);
        } else {
            this._processTemplateAction(element, templatingResult, this.action);
        }
    }

    protected void processTemplateAction(Element element, NodeList templatingResultNodeList) {
        if (element.getParentNode() instanceof Document) {
            int count = templatingResultNodeList.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = templatingResultNodeList.item(0);
                if (node.getNodeType() != 1) continue;
                this.processTemplateAction(element, node);
                break;
            }
        } else if (this.action == Action.REPLACE) {
            this.processTemplateAction(element, templatingResultNodeList, Action.INSERT_BEFORE);
            element.getParentNode().removeChild(element);
        } else {
            this.processTemplateAction(element, templatingResultNodeList, this.action);
        }
    }

    private void processTemplateAction(Element element, NodeList templatingResultNodeList, Action action) {
        int count = templatingResultNodeList.getLength();
        for (int i = 0; i < count; ++i) {
            this._processTemplateAction(element, templatingResultNodeList.item(0), action);
        }
    }

    private void _processTemplateAction(Element element, Node node, Action action) {
        Node parent = element.getParentNode();
        if (parent instanceof Document && (action == Action.INSERT_BEFORE || action == Action.INSERT_AFTER)) {
            this.logger.warn((Object)"Insert before/after root element not allowed.  Consider using the replace action!!");
            return;
        }
        if (action == Action.ADDTO) {
            element.appendChild(node);
        } else if (action == Action.INSERT_BEFORE) {
            DomUtils.insertBefore((Node)node, (Node)element);
        } else if (action == Action.INSERT_AFTER) {
            Node nextSibling = element.getNextSibling();
            if (nextSibling == null) {
                parent.appendChild(node);
            } else {
                DomUtils.insertBefore((Node)node, (Node)nextSibling);
            }
        } else if (action == Action.REPLACE) {
            // empty if block
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (this.visitBefore) {
            this.visit(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        if (!this.visitBefore) {
            this.visit(element, executionContext);
        }
    }

    protected abstract void visit(Element var1, ExecutionContext var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Action {
        REPLACE,
        ADDTO,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

