/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.xml.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sadun.util.Setup;
import org.sadun.util.xml.configuration.Configurator;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DispatcherHandler
extends DefaultHandler {
    private String packageName;
    private String postfix;
    private Stack elementsStack = new Stack();
    private Configurator currentConfigurator = null;
    private Map dispatcherMap = new HashMap();
    private Set dispatchLevels = new HashSet();
    private Stack configuratorsStack = new Stack();
    private Setup setupObject;

    protected DispatcherHandler(Setup setup, String string, String string2) {
        this.setupObject = setup;
        this.packageName = string;
        this.postfix = string2;
    }

    protected DispatcherHandler(String string, String string2) {
        this.setupObject = null;
        this.packageName = string;
        this.postfix = string2;
    }

    protected DispatcherHandler(String string) {
        this(string, "");
    }

    protected void setToDispatch(String string, String string2) {
        this.dispatcherMap.put(string + ":" + string2, this.makeConfiguratorClassNameFromQName(string2));
    }

    protected void setDispatchLevel(int n, boolean bl) {
        if (bl) {
            this.dispatchLevels.add(new Integer(n));
        } else {
            this.dispatchLevels.remove(new Integer(n));
        }
    }

    protected void setDispatchLevel(int n) {
        this.setDispatchLevel(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeConfiguratorClassNameFromQName(String string) {
        StringBuffer stringBuffer;
        String string2 = this.getTagFromQName(string);
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string2.charAt(i);
                if (bl) {
                    stringBuffer.append(Character.toUpperCase(c));
                    bl = false;
                    continue;
                }
                if (c == '-') {
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            string2 = stringBuffer.toString();
        }
        if (string2.endsWith("Configuration")) {
            string2 = string2.substring(0, string2.length() - 13);
        }
        return this.packageName + "." + string2 + this.postfix;
    }

    private String getTagFromQName(String string) {
        int n = string.indexOf(":");
        String string2 = n == -1 ? string : string.substring(n + 1);
        return string2;
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.elementsStack.push(string3);
        if (this.dispatchLevels.contains(new Integer(this.elementsStack.size())) || this.hasConfigurator(string, string2)) {
            String string4 = this.makeConfiguratorClassNameFromQName(string3);
            try {
                Class<?> clazz = Class.forName(string4);
                if (!Configurator.class.isAssignableFrom(clazz)) {
                    throw new SAXException("Internal error: the class " + string4 + " does not implement the Configurator interface");
                }
                try {
                    this.currentConfigurator = (Configurator)clazz.newInstance();
                    if (this.setupObject != null) {
                        this.setupObject.setup(this.currentConfigurator);
                    }
                    this.configuratorsStack.push(this.currentConfigurator);
                }
                catch (InstantiationException instantiationException) {
                    throw new SAXException("Could not instantiate XSpace configurator object", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXException("Could not access XSpace configurator object", illegalAccessException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXException(string3 + " configuration element not handled (class " + string4 + " not found");
            }
        }
        if (this.currentConfigurator != null) {
            this.currentConfigurator.startElement(string, string2, string3, attributes);
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.characters(cArray, n, n2);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.elementsStack.size() > 0) {
            this.elementsStack.pop();
        }
        if (this.currentConfigurator == null) {
            return;
        }
        this.currentConfigurator.endElement(string, string2, string3);
        if (this.dispatchLevels.contains(new Integer(this.elementsStack.size())) || this.hasConfigurator(string, string2)) {
            this.configuratorReady(string, string2, string3, this.currentConfigurator);
            this.currentConfigurator = this.configuratorsStack.size() == 0 ? null : (Configurator)this.configuratorsStack.pop();
        }
    }

    static String baseName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private boolean hasConfigurator(String string, String string2) {
        return this.dispatcherMap.containsKey(string + ":" + string2);
    }

    protected abstract void configuratorReady(String var1, String var2, String var3, Configurator var4) throws SAXException;

    public void endDocument() throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.endDocument();
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.endPrefixMapping(string);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.currentConfigurator)).error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.currentConfigurator)).fatalError(sAXParseException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof DTDHandler) {
            ((DTDHandler)((Object)this.currentConfigurator)).notationDecl(string, string2, string3);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.processingInstruction(string, string2);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof EntityResolver) {
            try {
                return ((EntityResolver)((Object)this.currentConfigurator)).resolveEntity(string, string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return super.resolveEntity(string, string2);
            }
        }
        return super.resolveEntity(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.setDocumentLocator(locator);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.skippedEntity(string);
        }
    }

    public void startDocument() throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.startDocument();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.currentConfigurator != null) {
            this.currentConfigurator.startPrefixMapping(string, string2);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof DTDHandler) {
            ((DTDHandler)((Object)this.currentConfigurator)).unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.currentConfigurator != null && this.currentConfigurator instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.currentConfigurator)).warning(sAXParseException);
        }
    }

    public Setup getSetupObject() {
        return this.setupObject;
    }

    public void setSetupObject(Setup setup) {
        this.setupObject = setup;
    }
}

