/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.xml.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sadun.util.FieldResolver;
import org.sadun.util.ObjectLister;
import org.sadun.util.TypeWrapper;
import org.sadun.util.xml.configuration.BaseConfigurator;
import org.xml.sax.SAXException;

public abstract class AutoConfigurator
extends BaseConfigurator {
    private Set setFields = new HashSet();
    private Set encounteredTags = new HashSet();
    private Set ignorableTags = new HashSet();
    private Set requiredFields = new HashSet();
    private Set requiredFieldsCopy = new HashSet();

    protected Field set(Object object, String string) throws SAXException {
        ArrayList arrayList = new ArrayList();
        this.encounteredTags.add(string);
        try {
            Field field = this.locateField(object, string, arrayList);
            Object object2 = TypeWrapper.convertValue(this.getTextAndResetBuffer(), field.getType());
            try {
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                field.set(object, object2);
                this.setFields.add(field.getName());
                field.setAccessible(bl);
                return field;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("Cannot set field " + field.getName() + " of type " + field.getClass() + " in class " + object.getClass() + " with value " + object, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAXException("Cannot access field " + field.getName() + " of type " + field.getClass() + " in class " + object.getClass(), illegalAccessException);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new SAXException("Cannot automatically locate field for tag '" + string + " in " + object.getClass().getName() + "' (attempted " + ObjectLister.getInstance().list(arrayList) + ") please use setOnTag() or setIgnore() to set esplicitly which field is associated to the tag", noSuchFieldException);
        }
    }

    public boolean hasFieldBeenSet(String string) {
        return this.setFields.contains(string);
    }

    public boolean hasTagBeenEncountered(String string) {
        return this.encounteredTags.contains(string);
    }

    public void setMandatory(String string) {
        this.requiredFields.add(string);
    }

    public boolean isMandatory(String string) {
        return this.requiredFields.contains(string);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.requiredFieldsCopy = new HashSet();
        if (this.requiredFields.size() > 0) {
            this.requiredFieldsCopy.addAll(this.requiredFields);
            this.completed = false;
        } else {
            this.completed = true;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.isIgnorableTag(string2)) {
            return;
        }
        String string4 = this.set(string2).getName();
        if (!this.completed) {
            this.requiredFieldsCopy.remove(string4);
            if (this.requiredFields.size() == 0) {
                this.completed = true;
            }
        }
    }

    public void setIgnore(String string) {
        this.ignorableTags.add(string);
    }

    public boolean isIgnorableTag(String string) {
        return this.ignorableTags.contains(string);
    }

    private Field locateField(Object object, String string, List list) throws NoSuchFieldException {
        String string2 = this.tagNameToFieldName1(string);
        list.add(string2);
        return FieldResolver.findField(object.getClass(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tagNameToFieldName1(String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
            boolean bl = false;
            for (int i = 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '-') {
                    bl = true;
                    continue;
                }
                if (bl) {
                    bl = false;
                    stringBuffer.append(Character.toUpperCase(c));
                    continue;
                }
                stringBuffer.append(Character.toLowerCase(c));
            }
        }
        return stringBuffer.toString();
    }

    protected Field set(String string) throws SAXException {
        return this.set(this, string);
    }

    protected abstract Object doGetConfiguredObject() throws SAXException;
}

