/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.watchdog.listeners;

import java.util.LinkedList;
import java.util.List;
import org.sadun.util.watchdog.WatchDog;
import org.sadun.util.watchdog.WatchDogException;
import org.sadun.util.watchdog.listeners.MaxRetryExceededException;

public abstract class WaitAndRetryListener
implements WatchDog.Listener {
    private int maxRetryCount;
    private int retryCount;
    private List retryOutcomes = new LinkedList();
    public static final int DEFAULT_MAX_RETRY_COUNT = 3;

    public WaitAndRetryListener() {
        this(3);
    }

    public WaitAndRetryListener(int n) {
        this.maxRetryCount = n;
        this.retryCount = 0;
    }

    public void checkOk(Object object) {
        this.reset();
    }

    public abstract void checkFailed(Object var1, Throwable var2);

    public void checkImpossible(Object object, WatchDogException watchDogException) {
        this.retryOutcomes.add(watchDogException);
        ++this.retryCount;
        if (this.retryCount == this.maxRetryCount) {
            this.checkFailed(object, new MaxRetryExceededException(this.maxRetryCount, this.retryOutcomes));
            this.reset();
        }
    }

    protected synchronized void reset() {
        this.retryCount = 0;
        this.retryOutcomes.clear();
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int n) {
        this.maxRetryCount = n;
    }
}

